/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.doc;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.Format;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.shell.impl.command.CRaSH;
import org.crsh.shell.impl.command.spi.Command;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;

public class Generator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File root = new File(args[0]);
        if (!root.exists()) {
            if (!root.mkdirs()) {
                throw new AssertionError((Object)("Could not create root directory " + root.getCanonicalPath()));
            }
        } else if (!root.isDirectory()) {
            throw new IllegalArgumentException("Wrong root directory argument " + root.getCanonicalPath());
        }
        FS cmdFS = new FS().mount(Thread.currentThread().getContextClassLoader(), Path.get((String)"/crash/commands/"));
        FS confFS = new FS().mount(Thread.currentThread().getContextClassLoader(), Path.get((String)"/crash/"));
        PluginContext ctx = new PluginContext((PluginDiscovery)new ServiceLoaderDiscovery(Thread.currentThread().getContextClassLoader()), Collections.emptyMap(), cmdFS, confFS, Thread.currentThread().getContextClassLoader());
        ctx.refresh();
        CRaSH crash = new CRaSH(ctx);
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry s : crash.getCommands()) {
            Command cmd = crash.getCommand((String)s.getKey());
            CommandDescriptor desc = cmd.getDescriptor();
            buffer.append("== ").append(desc.getName()).append("\n").append("\n");
            buffer.append("----\n");
            buffer.append(cmd.describe("", (Format)Format.MAN));
            buffer.append("----\n");
            for (CommandDescriptor m : desc.getSubordinates().values()) {
                buffer.append("=== ").append(desc.getName()).append(" ").append(m.getName()).append("\n").append("\n");
                buffer.append("----\n");
                buffer.append(cmd.describe(m.getName(), (Format)Format.MAN));
                buffer.append("----\n\n");
            }
        }
        if (buffer.length() > 0) {
            File f = new File(root, "reference.asciidoc");
            PrintWriter pw = new PrintWriter(f);
            try {
                System.out.println("Generating asciidoc file " + f.getCanonicalPath());
                pw.print(buffer);
            }
            finally {
                pw.close();
            }
        }
    }
}

