/*
 * Decompiled with CFR 0.152.
 */
package org.creekservice.internal.observability.logging.structured;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.creekservice.api.base.type.Preconditions;
import org.creekservice.api.observability.logging.structured.LogEntryCustomizer;

public final class DefaultLogEntryCustomizer
implements LogEntryCustomizer {
    private final Map<String, Object> metrics = new HashMap<String, Object>();
    private final Map<String, DefaultLogEntryCustomizer> namespaces = new HashMap<String, DefaultLogEntryCustomizer>();
    private final Throwable[] throwable;

    public static DefaultLogEntryCustomizer create(String messageText) {
        return (DefaultLogEntryCustomizer)new DefaultLogEntryCustomizer(new Throwable[1]).with(Field.message, (Object)messageText);
    }

    private DefaultLogEntryCustomizer(Throwable[] throwable) {
        this.throwable = Objects.requireNonNull(throwable, "throwable");
    }

    @Override
    public DefaultLogEntryCustomizer ns(String namespace) {
        if (this.metrics.containsKey(namespace)) {
            throw new IllegalArgumentException("Namespace name clashes with existing metric name: " + namespace);
        }
        return this.namespaces.computeIfAbsent(Preconditions.requireNonBlank((String)namespace, (String)"namespace"), k -> new DefaultLogEntryCustomizer(this.throwable));
    }

    @Override
    public LogEntryCustomizer with(String key, Object value) {
        Preconditions.requireNonBlank((String)key, (String)"key");
        if (this.namespaces.containsKey(key)) {
            throw new IllegalArgumentException("Metric name clashes with existing namespace name: " + key);
        }
        if (this.metrics.containsKey(key)) {
            throw new IllegalArgumentException("Metric key already set: " + key);
        }
        this.metrics.put(key, value);
        return this;
    }

    @Override
    public LogEntryCustomizer withThrowable(Throwable t) {
        if (this.throwable[0] != null) {
            throw new UnsupportedOperationException("Exception already set", this.throwable[0]);
        }
        this.throwable[0] = t;
        return this;
    }

    public Map<String, Object> build() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.metrics);
        this.namespaces.forEach((name, customizer) -> result.put((String)name, customizer.build()));
        DefaultLogEntryCustomizer.removeNullValues(result);
        return result.isEmpty() ? null : result;
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable[0]);
    }

    private static void removeNullValues(Map<String, Object> m) {
        m.values().removeAll(Collections.singleton(null));
    }

    public static enum Field {
        message;

    }
}

