/*
 * Decompiled with CFR 0.152.
 */
package org.creekservice.api.platform.resource;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.creekservice.api.base.type.CodeLocation;
import org.creekservice.api.observability.logging.structured.StructuredLogger;
import org.creekservice.api.observability.logging.structured.StructuredLoggerFactory;
import org.creekservice.api.platform.metadata.ComponentDescriptor;
import org.creekservice.api.platform.metadata.ResourceDescriptor;
import org.creekservice.api.platform.metadata.ResourceHandler;
import org.creekservice.internal.platform.resource.ComponentValidator;

public final class ResourceInitializer {
    private static final StructuredLogger LOGGER = StructuredLoggerFactory.internalLogger(ResourceInitializer.class);
    private final ResourceHandlers handlers;
    private final ComponentValidator componentValidator;

    public static ResourceInitializer resourceInitializer(ResourceHandlers handlers) {
        return new ResourceInitializer(handlers, new ComponentValidator());
    }

    ResourceInitializer(ResourceHandlers handlers, ComponentValidator componentValidator) {
        this.handlers = Objects.requireNonNull(handlers, "handlers");
        this.componentValidator = Objects.requireNonNull(componentValidator, "componentValidator");
    }

    public void init(Collection<? extends ComponentDescriptor> components) {
        LOGGER.debug("Initializing resources", log -> log.with("stage", (Object)"init").with("components", ResourceInitializer.componentNames(components)));
        this.ensureResources(this.groupById(components, resGroup -> resGroup.stream().anyMatch(ResourceDescriptor::isShared), false));
    }

    public void service(Collection<? extends ComponentDescriptor> components) {
        LOGGER.debug("Initializing resources", log -> log.with("stage", (Object)"service").with("components", ResourceInitializer.componentNames(components)));
        this.ensureResources(this.groupById(components, resGroup -> resGroup.stream().anyMatch(ResourceDescriptor::isOwned), true));
    }

    public void test(Collection<? extends ComponentDescriptor> componentsUnderTest, Collection<? extends ComponentDescriptor> otherComponents) {
        LOGGER.debug("Initializing resources", log -> log.with("stage", (Object)"test").with("components_under_test", ResourceInitializer.componentNames(componentsUnderTest)).with("other_components", ResourceInitializer.componentNames(otherComponents)));
        Map unowned = this.groupById(componentsUnderTest, resGroup -> resGroup.stream().anyMatch(ResourceDescriptor::isUnowned) && resGroup.stream().noneMatch(ResourceDescriptor::isOwned), true).collect(Collectors.toMap(group -> ((ResourceDescriptor)group.get(0)).id(), Function.identity()));
        this.groupById(otherComponents, resGroup -> resGroup.stream().anyMatch(r -> unowned.containsKey(r.id())), false).forEach(resGroup -> ((List)unowned.get(((ResourceDescriptor)resGroup.get(0)).id())).addAll(resGroup));
        Stream<List<ResourceDescriptor>> stream = unowned.values().stream();
        this.ensureResources(stream);
    }

    private void ensureResources(Stream<List<ResourceDescriptor>> resGroups) {
        resGroups.peek(this::validateResourceGroup).map(this::creatableDescriptor).collect(Collectors.groupingBy(this::resourceHandler)).forEach(ResourceHandler::ensure);
    }

    private ResourceDescriptor creatableDescriptor(List<ResourceDescriptor> resGroup) {
        return resGroup.stream().filter(ResourceDescriptor::isCreatable).findAny().orElseThrow(() -> new UncreatableResourceException(resGroup));
    }

    private Stream<List<ResourceDescriptor>> groupById(Collection<? extends ComponentDescriptor> components, Predicate<List<ResourceDescriptor>> groupPredicate, boolean validate) {
        Map<URI, List<ResourceDescriptor>> grouped = components.stream().flatMap(this::getResources).collect(Collectors.groupingBy(ResourceDescriptor::id));
        if (validate) {
            grouped.values().forEach(this::validateResourceGroup);
        }
        return grouped.values().stream().filter(groupPredicate);
    }

    private Stream<ResourceDescriptor> getResources(ComponentDescriptor component) {
        this.componentValidator.validate(component);
        return component.resources();
    }

    private <T extends ResourceDescriptor> void validateResourceGroup(List<T> resourceGroup) {
        if (ResourceDescriptor.isShared((ResourceDescriptor)((ResourceDescriptor)resourceGroup.get(0)))) {
            if (resourceGroup.stream().anyMatch(r -> !ResourceDescriptor.isShared((ResourceDescriptor)r))) {
                throw new ResourceDescriptorMismatchInitializationException("shared", resourceGroup);
            }
        } else if (ResourceDescriptor.isUnmanaged((ResourceDescriptor)((ResourceDescriptor)resourceGroup.get(0)))) {
            if (resourceGroup.stream().anyMatch(r -> !ResourceDescriptor.isUnmanaged((ResourceDescriptor)r))) {
                throw new ResourceDescriptorMismatchInitializationException("unmanaged", resourceGroup);
            }
        } else if (resourceGroup.stream().anyMatch(r -> !ResourceDescriptor.isOwned((ResourceDescriptor)r) && !ResourceDescriptor.isUnowned((ResourceDescriptor)r))) {
            throw new ResourceDescriptorMismatchInitializationException("owned or unowned", resourceGroup);
        }
    }

    private <T extends ResourceDescriptor> ResourceHandler<T> resourceHandler(T resource) {
        return this.handlers.get(resource.getClass());
    }

    private static String formatResource(List<? extends ResourceDescriptor> descriptors) {
        return descriptors.stream().map(ResourceInitializer::formatResource).collect(Collectors.joining(", ", "[", "]"));
    }

    private static String formatResource(ResourceDescriptor descriptor) {
        return "(" + CodeLocation.codeLocation((Object)descriptor) + ") " + descriptor;
    }

    private static List<String> componentNames(Collection<? extends ComponentDescriptor> components) {
        return components.stream().map(ComponentDescriptor::name).collect(Collectors.toList());
    }

    private static final class UncreatableResourceException
    extends RuntimeException {
        UncreatableResourceException(List<? extends ResourceDescriptor> descriptors) {
            super("No component provided a creatable descriptor for resource id: " + descriptors.get(0).id() + ", descriptors: " + ResourceInitializer.formatResource(descriptors));
        }
    }

    private static final class ResourceDescriptorMismatchInitializationException
    extends ResourceDescriptorMismatchException {
        ResourceDescriptorMismatchInitializationException(String type, List<? extends ResourceDescriptor> descriptors) {
            super("Resource descriptors for resource are tagged with incompatible resource initialization marker interfaces. First descriptor is marked as a " + type + " resource, but at least one subsequent descriptor was not " + type, descriptors);
        }
    }

    private static class ResourceDescriptorMismatchException
    extends RuntimeException {
        ResourceDescriptorMismatchException(String msg, List<? extends ResourceDescriptor> descriptors) {
            super(msg + ". resource: " + descriptors.get(0).id() + ", descriptors: " + ResourceInitializer.formatResource(descriptors));
        }
    }

    @FunctionalInterface
    public static interface ResourceHandlers {
        public <T extends ResourceDescriptor> ResourceHandler<T> get(Class<T> var1);
    }
}

