/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.asym.elgamal;

import java.util.Objects;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class ElgamalCipherText
implements CipherText {
    @Represented(restorer="G")
    private GroupElement c1;
    @Represented(restorer="G")
    private GroupElement c2;

    public ElgamalCipherText(Representation repr, Group group) {
        new ReprUtil((Object)this).register((RepresentationRestorer)group, "G").deserialize(repr);
    }

    public ElgamalCipherText(GroupElement c1, GroupElement c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public String toString() {
        return "(" + this.c1.toString() + ", " + this.c2.toString() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.c1 == null ? 0 : this.c1.hashCode());
        result = 31 * result + (this.c2 == null ? 0 : this.c2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElgamalCipherText other = (ElgamalCipherText)obj;
        return Objects.equals(this.c1, other.c1) && Objects.equals(this.c2, other.c2);
    }

    public GroupElement getC1() {
        return this.c1;
    }

    public GroupElement getC2() {
        return this.c2;
    }
}

