/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.asym.elgamal;

import java.util.Objects;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class ElgamalPublicKey
implements EncryptionKey {
    @UniqueByteRepresented
    @Represented(restorer="groupG")
    private GroupElement g;
    @UniqueByteRepresented
    @Represented(restorer="groupG")
    private GroupElement h;

    public ElgamalPublicKey(GroupElement g, GroupElement h) {
        this.g = g;
        this.h = h;
    }

    public ElgamalPublicKey(Representation repr, Group group) {
        new ReprUtil((Object)this).register((RepresentationRestorer)group, "groupG").deserialize(repr);
    }

    public GroupElement getG() {
        return this.g;
    }

    public GroupElement getH() {
        return this.h;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.g == null ? 0 : this.g.hashCode());
        result = 31 * result + (this.h == null ? 0 : this.h.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElgamalPublicKey other = (ElgamalPublicKey)obj;
        return Objects.equals(this.g, other.g) && Objects.equals(this.h, other.h);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }
}

