/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.damgardtechnique;

import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.commitment.hashthencommit.HashThenCommitCommitmentScheme;
import org.cryptimeleon.craco.commitment.pedersen.PedersenCommitmentScheme;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.damgardtechnique.DamgardAnnouncement;
import org.cryptimeleon.craco.protocols.arguments.damgardtechnique.DamgardAnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.damgardtechnique.DamgardResponse;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.VariableOutputLengthHashFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.Group;

public class DamgardTechnique
implements SigmaProtocol {
    protected SigmaProtocol innerProtocol;
    protected CommitmentScheme commitmentScheme;

    public DamgardTechnique(SigmaProtocol innerProtocol, CommitmentScheme commitmentScheme) {
        this.innerProtocol = innerProtocol;
        this.commitmentScheme = commitmentScheme;
    }

    @Override
    public DamgardAnnouncementSecret generateAnnouncementSecret(CommonInput commonInput, SecretInput secretInput) {
        AnnouncementSecret innerSecret = this.innerProtocol.generateAnnouncementSecret(commonInput, secretInput);
        Announcement innerAnnouncement = this.innerProtocol.generateAnnouncement(commonInput, secretInput, innerSecret);
        CommitmentPair commitment = this.commitmentScheme.commit(this.announcementToCommitmentPlaintext(innerAnnouncement));
        return new DamgardAnnouncementSecret(innerSecret, innerAnnouncement, commitment);
    }

    @Override
    public Announcement generateAnnouncement(CommonInput commonInput, SecretInput secretInput, AnnouncementSecret announcementSecret) {
        return new DamgardAnnouncement(((DamgardAnnouncementSecret)announcementSecret).commitment.getCommitment());
    }

    @Override
    public Challenge generateChallenge(CommonInput commonInput) {
        return this.innerProtocol.generateChallenge(commonInput);
    }

    @Override
    public Response generateResponse(CommonInput commonInput, SecretInput secretInput, Announcement announcement, AnnouncementSecret announcementSecret, Challenge challenge) {
        Response innerResponse = this.innerProtocol.generateResponse(commonInput, secretInput, ((DamgardAnnouncementSecret)announcementSecret).innerAnnouncement, ((DamgardAnnouncementSecret)announcementSecret).innerAnnouncementSecret, challenge);
        Announcement innerAnnouncement = ((DamgardAnnouncementSecret)announcementSecret).innerAnnouncement;
        Representation compressedTranscript = this.innerProtocol.compressTranscript(commonInput, new SigmaProtocolTranscript(innerAnnouncement, challenge, innerResponse));
        return new DamgardResponse(innerResponse, innerAnnouncement, ((DamgardAnnouncementSecret)announcementSecret).commitment.getOpenValue(), compressedTranscript);
    }

    @Override
    public BooleanExpression checkTranscriptAsExpression(CommonInput commonInput, Announcement announcement, Challenge challenge, Response response) {
        if (!this.commitmentScheme.verify(((DamgardAnnouncement)announcement).getCommitment(), ((DamgardResponse)response).getOpenValue(), this.announcementToCommitmentPlaintext(((DamgardResponse)response).getInnerAnnouncement()))) {
            return BooleanExpression.FALSE;
        }
        return this.innerProtocol.checkTranscriptAsExpression(commonInput, ((DamgardResponse)response).getInnerAnnouncement(), challenge, ((DamgardResponse)response).getInnerResponse());
    }

    @Override
    public SigmaProtocolTranscript generateSimulatedTranscript(CommonInput commonInput, Challenge challenge) {
        SigmaProtocolTranscript inner = this.innerProtocol.generateSimulatedTranscript(commonInput, challenge);
        Representation compressedInnerTranscript = this.innerProtocol.compressTranscript(commonInput, inner);
        CommitmentPair commitmentAndOpening = this.commitmentScheme.commit(this.announcementToCommitmentPlaintext(inner.getAnnouncement()));
        return new SigmaProtocolTranscript(new DamgardAnnouncement(commitmentAndOpening.getCommitment()), challenge, new DamgardResponse(inner.getResponse(), inner.getAnnouncement(), commitmentAndOpening.getOpenValue(), compressedInnerTranscript));
    }

    @Override
    public DamgardAnnouncement restoreAnnouncement(CommonInput commonInput, Representation repr) {
        return new DamgardAnnouncement(repr, this.commitmentScheme);
    }

    @Override
    public Challenge restoreChallenge(CommonInput commonInput, Representation repr) {
        return this.innerProtocol.restoreChallenge(commonInput, repr);
    }

    @Override
    public DamgardResponse restoreResponse(CommonInput commonInput, Announcement announcement, Challenge challenge, Representation repr) {
        SigmaProtocolTranscript transcript = this.innerProtocol.decompressTranscript(commonInput, challenge, repr.obj().get("compressedTranscript"));
        return new DamgardResponse(transcript.getResponse(), transcript.getAnnouncement(), this.commitmentScheme.restoreOpenValue(repr.obj().get("openValue")), repr.obj().get("compressedTranscript"));
    }

    @Override
    public ChallengeSpace getChallengeSpace(CommonInput commonInput) {
        return this.innerProtocol.getChallengeSpace(commonInput);
    }

    protected PlainText announcementToCommitmentPlaintext(Announcement innerAnnouncement) {
        return new ByteArrayImplementation(innerAnnouncement.getUniqueByteRepresentation());
    }

    public static CommitmentScheme generateCommitmentScheme(Group group) {
        return new HashThenCommitCommitmentScheme(new PedersenCommitmentScheme(group, 1), (HashFunction)new VariableOutputLengthHashFunction((group.size().bitLength() - 1) / 8));
    }

    @Override
    public void debugProof(CommonInput commonInput, SecretInput secretInput) {
        this.innerProtocol.debugProof(commonInput, secretInput);
        try {
            SigmaProtocol.super.debugProof(commonInput, secretInput);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("No error checking the inner protocol, but something seems to be wrong running the protocol. Maybe a hashing issue.", e);
        }
    }
}

