/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.SecretInput;
import org.cryptimeleon.craco.protocols.arguments.InteractiveArgument;
import org.cryptimeleon.craco.protocols.arguments.InteractiveArgumentInstance;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.craco.protocols.arguments.sigma.instance.SigmaProtocolProverInstance;
import org.cryptimeleon.craco.protocols.arguments.sigma.instance.SigmaProtocolVerifierInstance;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.serialization.Representation;

public interface SigmaProtocol
extends InteractiveArgument {
    public AnnouncementSecret generateAnnouncementSecret(CommonInput var1, SecretInput var2);

    public Announcement generateAnnouncement(CommonInput var1, SecretInput var2, AnnouncementSecret var3);

    default public Challenge generateChallenge(CommonInput commonInput) {
        return this.getChallengeSpace(commonInput).generateRandomChallenge();
    }

    public ChallengeSpace getChallengeSpace(CommonInput var1);

    public Response generateResponse(CommonInput var1, SecretInput var2, Announcement var3, AnnouncementSecret var4, Challenge var5);

    default public boolean checkTranscript(CommonInput commonInput, Announcement announcement, Challenge challenge, Response response) {
        return this.checkTranscriptAsExpression(commonInput, announcement, challenge, response).evaluateLazy().getResult();
    }

    public BooleanExpression checkTranscriptAsExpression(CommonInput var1, Announcement var2, Challenge var3, Response var4);

    default public boolean checkTranscript(CommonInput commonInput, SigmaProtocolTranscript transcript) {
        return this.checkTranscript(commonInput, transcript.getAnnouncement(), transcript.getChallenge(), transcript.getResponse());
    }

    default public Representation compressTranscript(CommonInput commonInput, SigmaProtocolTranscript transcript) {
        return transcript.getRepresentation();
    }

    default public SigmaProtocolTranscript decompressTranscript(CommonInput commonInput, Challenge challenge, Representation compressedTranscript) throws IllegalArgumentException {
        SigmaProtocolTranscript transcript = this.restoreTranscript(compressedTranscript, commonInput);
        if (!this.checkTranscript(commonInput, transcript) || !challenge.equals(transcript.getChallenge())) {
            throw new IllegalArgumentException("Invalid transcript or challenge");
        }
        return transcript;
    }

    public SigmaProtocolTranscript generateSimulatedTranscript(CommonInput var1, Challenge var2);

    public Announcement restoreAnnouncement(CommonInput var1, Representation var2);

    default public Challenge restoreChallenge(CommonInput commonInput, Representation repr) {
        return this.getChallengeSpace(commonInput).restoreChallenge(repr);
    }

    public Response restoreResponse(CommonInput var1, Announcement var2, Challenge var3, Representation var4);

    default public SigmaProtocolTranscript restoreTranscript(Representation repr, CommonInput commonInput) {
        return new SigmaProtocolTranscript(this, commonInput, repr);
    }

    @Override
    default public String getFirstMessageRole() {
        return "prover";
    }

    @Override
    default public InteractiveArgumentInstance instantiateProtocol(String role, CommonInput commonInput, SecretInput secretInput) {
        return "prover".equals(role) ? new SigmaProtocolProverInstance(this, commonInput, secretInput) : ("verifier".equals(role) ? new SigmaProtocolVerifierInstance(this, commonInput) : null);
    }

    default public SigmaProtocolProverInstance getProverInstance(CommonInput commonInput, SecretInput secretInput) {
        return new SigmaProtocolProverInstance(this, commonInput, secretInput);
    }

    default public SigmaProtocolVerifierInstance getVerifierInstance(CommonInput commonInput) {
        return new SigmaProtocolVerifierInstance(this, commonInput);
    }
}

