/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.instance;

import org.cryptimeleon.craco.protocols.CommonInput;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocol;
import org.cryptimeleon.craco.protocols.arguments.sigma.instance.SigmaProtocolInstance;
import org.cryptimeleon.math.serialization.Representation;

public class SigmaProtocolVerifierInstance
extends SigmaProtocolInstance {
    protected State state = State.NOTHING;

    public SigmaProtocolVerifierInstance(SigmaProtocol protocol, CommonInput commonInput) {
        super(protocol, commonInput);
    }

    @Override
    public String getRoleName() {
        return "verifier";
    }

    @Override
    public Representation nextMessage(Representation received) {
        switch (this.state) {
            case NOTHING: {
                this.announcement = this.protocol.restoreAnnouncement(this.commonInput, received);
                this.challenge = this.protocol.generateChallenge(this.commonInput);
                this.state = State.SENT_CHALLENGE;
                return this.challenge.getRepresentation();
            }
            case SENT_CHALLENGE: {
                this.response = this.protocol.restoreResponse(this.commonInput, this.announcement, this.challenge, received);
                this.state = State.RECEIVED_RESPONSE;
                return null;
            }
            case RECEIVED_RESPONSE: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected state for Sigma protocol instance: " + this.state.toString());
    }

    @Override
    public boolean hasTerminated() {
        return this.state == State.RECEIVED_RESPONSE;
    }

    static enum State {
        NOTHING,
        SENT_CHALLENGE,
        RECEIVED_RESPONSE;

    }
}

