/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership;

import java.math.BigInteger;
import java.util.stream.IntStream;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.DelegateFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.LinearExponentStatementFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendThenDelegateFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership.SetMembershipFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.setmembership.SetMembershipPublicParameters;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrZnVariable;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentEmptyExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.integers.IntegerRing;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class SmallerThanPowerFragment
extends DelegateFragment {
    protected final int base;
    protected final int power;
    protected final ExponentExpr member;
    protected final SetMembershipPublicParameters pp;

    public SmallerThanPowerFragment(ExponentExpr member, int base, int power, SetMembershipPublicParameters pp) {
        this.base = base;
        this.power = power;
        this.member = member;
        this.pp = pp;
        if (pp.signatures.size() != base || IntStream.range(0, base).anyMatch(i -> !pp.signatures.containsKey(BigInteger.valueOf(i)))) {
            throw new IllegalArgumentException("Unfit SetMembershiptPublicParameters");
        }
    }

    public static SetMembershipPublicParameters generatePublicParameters(BilinearGroup group, int base) {
        return SetMembershipPublicParameters.generateInterval(group, 0, base);
    }

    @Override
    protected SendThenDelegateFragment.ProverSpec provideProverSpecWithNoSendFirst(SchnorrVariableAssignment externalWitnesses, SendThenDelegateFragment.ProverSpecBuilder builder) {
        Zn.ZnElement memberVal = this.member.evaluate(this.pp.getZn(), (Substitution)externalWitnesses);
        BigInteger[] digits = IntegerRing.decomposeIntoDigits((BigInteger)memberVal.asInteger(), (BigInteger)BigInteger.valueOf(this.base), (int)this.power);
        for (int i = 0; i < this.power; ++i) {
            builder.putWitnessValue("digit" + i, this.pp.getZn().valueOf(digits[i]));
        }
        return builder.build();
    }

    @Override
    protected SendThenDelegateFragment.SubprotocolSpec provideSubprotocolSpec(SendThenDelegateFragment.SubprotocolSpecBuilder builder) {
        int i;
        SchnorrZnVariable[] digits = new SchnorrZnVariable[this.power];
        for (int i2 = 0; i2 < this.power; ++i2) {
            digits[i2] = builder.addZnVariable("digit" + i2, this.pp.getZn());
        }
        Zn.ZnElement base = this.pp.getZn().valueOf((long)this.base);
        ExponentEmptyExpr weightedSum = new ExponentEmptyExpr();
        for (i = 0; i < this.power; ++i) {
            weightedSum = weightedSum.add(digits[i].mul((RingElement)base.pow((long)i)));
        }
        builder.addSubprotocol("digitSum", new LinearExponentStatementFragment(weightedSum.isEqualTo(this.member), this.pp.getZn()));
        for (i = 0; i < this.power; ++i) {
            builder.addSubprotocol("digit" + i + "valid", new SetMembershipFragment(this.pp, (ExponentExpr)digits[i]));
        }
        return builder.build();
    }
}

