/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.base;

import java.util.HashMap;
import java.util.HashSet;
import org.cryptimeleon.craco.protocols.TwoPartyProtocol;
import org.cryptimeleon.craco.protocols.TwoPartyProtocolInstance;
import org.cryptimeleon.craco.protocols.arguments.InteractiveArgumentInstance;
import org.cryptimeleon.craco.protocols.base.BaseProtocol;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;

public abstract class BaseProtocolInstance
implements TwoPartyProtocolInstance {
    static final String HIGH_LEVEL_PROT_MSGS = "high_level_prot_msgs";
    private final BaseProtocol protocol;
    private final String role;
    private int round = 0;
    private HashMap<String, TwoPartyProtocolInstance> newSubprotocolInstances = new HashMap();
    private final HashMap<String, TwoPartyProtocolInstance> runningSubprotocolInstances = new HashMap();
    private final HashSet<String> argumentsToCheck = new HashSet();
    private HashMap<String, Representation> valuesToSendNext = new HashMap();
    private final HashMap<String, Representation> valuesReceived = new HashMap();
    private boolean highLevelWantsTerminate = false;

    public BaseProtocolInstance(BaseProtocol protocol, String role) {
        this.protocol = protocol;
        this.role = role;
        this.round = this.sendsFirstMessage() ? 0 : 1;
    }

    @Override
    public TwoPartyProtocol getProtocol() {
        return this.protocol;
    }

    protected void runSubprotocolConcurrently(String instanceName, TwoPartyProtocolInstance instance) {
        this.newSubprotocolInstances.put(instanceName, instance);
    }

    protected void runArgumentConcurrently(String instanceName, InteractiveArgumentInstance instance) {
        this.runSubprotocolConcurrently(instanceName, instance);
        this.argumentsToCheck.add(instanceName);
    }

    protected void send(String id, Representation repr) {
        if (id == null || id.equals(HIGH_LEVEL_PROT_MSGS)) {
            throw new IllegalArgumentException("illegal id");
        }
        this.valuesToSendNext.put(id, repr);
    }

    protected Representation receive(String id) {
        if (!this.valuesReceived.containsKey(id)) {
            throw new IllegalArgumentException("Have not received " + id);
        }
        Representation received = this.valuesReceived.get(id);
        this.valuesReceived.remove(id);
        return received;
    }

    protected void terminate() {
        this.highLevelWantsTerminate = true;
    }

    @Override
    public Representation nextMessage(Representation received) {
        ObjectRepresentation toSend = new ObjectRepresentation();
        if (received != null) {
            received.obj().get(HIGH_LEVEL_PROT_MSGS).obj().forEach(e -> this.valuesReceived.putIfAbsent((String)e.getKey(), (Representation)e.getValue()));
        }
        this.runningSubprotocolInstances.forEach((name, instance) -> {
            Representation nextMsg = instance.nextMessage(received.obj().get(name));
            if (nextMsg != null) {
                toSend.put(name, nextMsg);
            }
        });
        this.runningSubprotocolInstances.forEach((name, instance) -> {
            if (this.argumentsToCheck.contains(name) && instance.hasTerminated() && instance.getRoleName().equals("verifier") && !((InteractiveArgumentInstance)instance).isAccepting()) {
                throw new IllegalStateException("Proof " + name + " failed.");
            }
        });
        this.internalDoRound(this.round);
        this.round += 2;
        ObjectRepresentation high_level_prot_msgs = new ObjectRepresentation();
        this.valuesToSendNext.forEach((arg_0, arg_1) -> ((ObjectRepresentation)high_level_prot_msgs).put(arg_0, arg_1));
        this.valuesToSendNext = new HashMap();
        toSend.put(HIGH_LEVEL_PROT_MSGS, (Representation)high_level_prot_msgs);
        this.newSubprotocolInstances.forEach((name, instance) -> {
            if (instance.sendsFirstMessage()) {
                toSend.put(name, instance.nextMessage(null));
            } else {
                Representation nextMsg = instance.nextMessage(received.obj().get(name));
                if (nextMsg != null) {
                    toSend.put(name, nextMsg);
                }
            }
            this.runningSubprotocolInstances.put((String)name, (TwoPartyProtocolInstance)instance);
        });
        this.newSubprotocolInstances = new HashMap();
        this.runningSubprotocolInstances.entrySet().removeIf(e -> ((TwoPartyProtocolInstance)e.getValue()).hasTerminated());
        return toSend;
    }

    protected void internalDoRound(int round) {
        if (this.role.equals(this.getProtocol().getFirstMessageRole())) {
            this.doRoundForFirstRole(round);
        } else {
            this.doRoundForSecondRole(round);
        }
    }

    protected abstract void doRoundForFirstRole(int var1);

    protected abstract void doRoundForSecondRole(int var1);

    @Override
    public boolean hasTerminated() {
        return this.highLevelWantsTerminate && this.runningSubprotocolInstances.isEmpty();
    }

    @Override
    public String getRoleName() {
        return this.role;
    }
}

