/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig;

import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.StandardMultiMessageSignatureScheme;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;

public interface MultiMessageStructurePreservingSignatureScheme
extends StandardMultiMessageSignatureScheme {
    default public Signature sign(SigningKey secretKey, GroupElement ... groupElements) {
        return this.sign(secretKey, new GroupElementVector(groupElements));
    }

    default public Boolean verify(VerificationKey verificationKey, Signature signature, GroupElement ... groupElements) {
        return this.verify(verificationKey, signature, new GroupElementVector(groupElements));
    }

    default public Signature sign(SigningKey secretKey, GroupElementVector groupElements) {
        return this.sign(new MessageBlock((Vector<? extends PlainText>)groupElements.map(GroupElementPlainText::new)), secretKey);
    }

    default public Boolean verify(VerificationKey verificationKey, Signature signature, GroupElementVector groupElements) {
        return this.verify(new MessageBlock((Vector<? extends PlainText>)groupElements.map(GroupElementPlainText::new)), signature, verificationKey);
    }
}

