/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.bbs;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.mappings.GroupHomomorphism;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class BBSBPublicParameter
implements PublicParameters {
    @Represented
    private BilinearGroup bilinearGroup;
    @Represented
    private HashIntoZn hashIntoZp;
    @Represented(restorer="bilinearGroup::getG1")
    private GroupElement g1;
    @Represented(restorer="bilinearGroup::getG2")
    private GroupElement g2;

    public BBSBPublicParameter(BilinearGroup bilinearGroup, HashIntoZn hashIntoZp) {
        this.bilinearGroup = bilinearGroup;
        this.hashIntoZp = hashIntoZp;
    }

    public BBSBPublicParameter(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public BilinearGroup getBilinearGroup() {
        return this.bilinearGroup;
    }

    public GroupElement getG1() {
        return this.g1;
    }

    public void setG1(GroupElement g1) {
        this.g1 = g1;
    }

    public GroupElement getG2() {
        return this.g2;
    }

    public void setG2(GroupElement g2) {
        this.g2 = g2;
    }

    public Zp getZp() {
        return new Zp(this.bilinearGroup.getZn().size());
    }

    public BigInteger getGroupSize() {
        return this.getZp().size();
    }

    public HashIntoZn getHashIntoZp() {
        return this.hashIntoZp;
    }

    public int hashCode() {
        return Objects.hash(this.bilinearGroup, this.hashIntoZp, this.g1, this.g2);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BBSBPublicParameter that = (BBSBPublicParameter)other;
        return Objects.equals(this.bilinearGroup, that.bilinearGroup) && Objects.equals(this.hashIntoZp, that.hashIntoZp) && Objects.equals(this.g1, that.g1) && Objects.equals(this.g2, that.g2);
    }

    public GroupHomomorphism getGroupHom() {
        return this.bilinearGroup.getHomomorphismG2toG1();
    }

    public BilinearMap getBilinearMap() {
        return this.bilinearGroup.getBilinearMap();
    }

    public Group getGroupG1() {
        return this.bilinearGroup.getG1();
    }

    public Group getGroupG2() {
        return this.bilinearGroup.getG2();
    }
}

