/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.eq;

import java.util.Objects;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class SPSEQSignature
implements Signature,
UniqueByteRepresentable {
    @UniqueByteRepresented
    @Represented(restorer="G1")
    protected GroupElement group1ElementSigma1Z;
    @UniqueByteRepresented
    @Represented(restorer="G1")
    protected GroupElement group1ElementSigma2Y;
    @UniqueByteRepresented
    @Represented(restorer="G2")
    protected GroupElement group2ElementSigma3HatY;

    public SPSEQSignature(Representation repr, Group groupG1, Group groupG2) {
        new ReprUtil((Object)this).register((RepresentationRestorer)groupG1, "G1").register((RepresentationRestorer)groupG2, "G2").deserialize(repr);
    }

    public SPSEQSignature(GroupElement group1ElementSigma1Z, GroupElement group1ElementSigma2Y, GroupElement group1ElementSigma3HatY) {
        this.group1ElementSigma1Z = group1ElementSigma1Z;
        this.group1ElementSigma2Y = group1ElementSigma2Y;
        this.group2ElementSigma3HatY = group1ElementSigma3HatY;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public GroupElement getGroup1ElementSigma1Z() {
        return this.group1ElementSigma1Z;
    }

    public void setGroup1ElementSigma1Z(GroupElement group1ElementSigma1Z) {
        this.group1ElementSigma1Z = group1ElementSigma1Z;
    }

    public GroupElement getGroup1ElementSigma2Y() {
        return this.group1ElementSigma2Y;
    }

    public void setGroup1ElementSigma2Y(GroupElement group1ElementSigma2Y) {
        this.group1ElementSigma2Y = group1ElementSigma2Y;
    }

    public GroupElement getGroup2ElementSigma3HatY() {
        return this.group2ElementSigma3HatY;
    }

    public void setGroup2ElementSigma3HatY(GroupElement group2ElementSigma3HatY) {
        this.group2ElementSigma3HatY = group2ElementSigma3HatY;
    }

    public String toString() {
        return "SPSEQSignature [sigma_1_Z=" + this.group1ElementSigma1Z + ", sigma_2_Y=" + this.group1ElementSigma2Y + ", sigma_3_Hat_Y" + this.group2ElementSigma3HatY + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SPSEQSignature that = (SPSEQSignature)o;
        return Objects.equals(this.group1ElementSigma1Z, that.group1ElementSigma1Z) && Objects.equals(this.group1ElementSigma2Y, that.group1ElementSigma2Y) && Objects.equals(this.group2ElementSigma3HatY, that.group2ElementSigma3HatY);
    }

    public int hashCode() {
        return Objects.hash(this.group1ElementSigma1Z, this.group1ElementSigma2Y, this.group2ElementSigma3HatY);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }
}

