/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.groth15;

import java.util.Objects;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;

public class SPSGroth15Signature
implements Signature,
UniqueByteRepresentable {
    @UniqueByteRepresented
    @Represented(restorer="otherGroup")
    protected GroupElement groupElementSigma1HatR;
    @UniqueByteRepresented
    @Represented(restorer="plaintextGroup")
    protected GroupElement groupElementSigma2S;
    @UniqueByteRepresented
    @Represented(restorer="plaintextGroup")
    protected GroupElementVector groupElementSigma3Ti;

    public SPSGroth15Signature(Representation repr, Group plaintextGroup, Group otherGroup) {
        new ReprUtil((Object)this).register((RepresentationRestorer)plaintextGroup, "plaintextGroup").register((RepresentationRestorer)otherGroup, "otherGroup").deserialize(repr);
    }

    public SPSGroth15Signature(GroupElement group2ElementSigma1HatR, GroupElement group1ElementSigma2S, GroupElementVector group1ElementSigma3Ti) {
        this.groupElementSigma1HatR = group2ElementSigma1HatR;
        this.groupElementSigma2S = group1ElementSigma2S;
        this.groupElementSigma3Ti = group1ElementSigma3Ti;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public GroupElement getGroupElementSigma1HatR() {
        return this.groupElementSigma1HatR;
    }

    public GroupElement getGroupElementSigma2S() {
        return this.groupElementSigma2S;
    }

    public GroupElementVector getGroupElementSigma3Ti() {
        return this.groupElementSigma3Ti;
    }

    public String toString() {
        return "SPSGroth15Signature [sigma_1_Hat_R=" + this.groupElementSigma1HatR + ", sigma_2_S=" + this.groupElementSigma2S + ", sigma_3_T" + this.groupElementSigma3Ti + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SPSGroth15Signature that = (SPSGroth15Signature)o;
        return Objects.equals(this.groupElementSigma1HatR, that.groupElementSigma1HatR) && Objects.equals(this.groupElementSigma2S, that.groupElementSigma2S) && Objects.equals(this.groupElementSigma3Ti, that.groupElementSigma3Ti);
    }

    public int hashCode() {
        return Objects.hash(this.groupElementSigma1HatR, this.groupElementSigma2S, this.groupElementSigma3Ti);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }
}

