/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.commitment.hashthencommit;

import java.util.Objects;
import org.cryptimeleon.craco.commitment.Commitment;
import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.commitment.OpenValue;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;

public class HashThenCommitCommitmentScheme
implements CommitmentScheme {
    @Represented
    private CommitmentScheme encapsulatedScheme;
    @Represented
    private HashFunction hashFunction;

    public HashThenCommitCommitmentScheme(CommitmentScheme encapsulatedScheme, HashFunction hashFunction) {
        if (hashFunction.getOutputLength() > encapsulatedScheme.getMaxNumberOfBytesForMapToPlaintext()) {
            throw new IllegalArgumentException("The given hash function is incompatible with the given commitment scheme! The output length is too large.");
        }
        this.encapsulatedScheme = encapsulatedScheme;
        this.hashFunction = hashFunction;
    }

    public HashThenCommitCommitmentScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    @Override
    public CommitmentPair commit(PlainText plainText) {
        ByteArrayImplementation pt = !(plainText instanceof ByteArrayImplementation) ? new ByteArrayImplementation(plainText.getUniqueByteRepresentation()) : (ByteArrayImplementation)plainText;
        byte[] hashedBytes = this.hashFunction.hash(pt.getData());
        PlainText hashedPlainText = this.encapsulatedScheme.mapToPlaintext(hashedBytes);
        return this.encapsulatedScheme.commit(hashedPlainText);
    }

    @Override
    public boolean verify(Commitment commitment, OpenValue openValue, PlainText plainText) {
        ByteArrayImplementation pt = !(plainText instanceof ByteArrayImplementation) ? (ByteArrayImplementation)this.mapToPlaintext(plainText.getUniqueByteRepresentation()) : (ByteArrayImplementation)plainText;
        byte[] hashedBytes = this.hashFunction.hash(pt.getData());
        PlainText hashedPlainText = this.encapsulatedScheme.mapToPlaintext(hashedBytes);
        return this.encapsulatedScheme.verify(commitment, openValue, hashedPlainText);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes) throws IllegalArgumentException {
        return new ByteArrayImplementation(bytes);
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Commitment restoreCommitment(Representation repr) {
        return this.encapsulatedScheme.restoreCommitment(repr);
    }

    @Override
    public OpenValue restoreOpenValue(Representation repr) {
        return this.encapsulatedScheme.restoreOpenValue(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashThenCommitCommitmentScheme other = (HashThenCommitCommitmentScheme)o;
        return Objects.equals(this.encapsulatedScheme, other.encapsulatedScheme) && Objects.equals(this.hashFunction, other.hashFunction);
    }

    public int hashCode() {
        return Objects.hash(this.encapsulatedScheme, this.hashFunction);
    }
}

