/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.attributes;

import java.math.BigInteger;
import java.util.Collection;
import org.cryptimeleon.craco.common.attributes.Attribute;
import org.cryptimeleon.craco.common.policies.PolicyFact;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;

public class BigIntegerAttribute
implements Attribute {
    @UniqueByteRepresented
    private BigInteger element;

    public BigIntegerAttribute(Integer element) {
        this.element = BigInteger.valueOf(element.intValue());
    }

    public BigIntegerAttribute(BigInteger element) {
        this.element = element;
    }

    public BigIntegerAttribute(Representation repr) {
        this.element = repr.obj().get("elem").bigInt().get();
    }

    public BigInteger getAttribute() {
        return this.element;
    }

    public Representation getRepresentation() {
        ObjectRepresentation result = new ObjectRepresentation();
        result.put("elem", (Representation)new BigIntegerRepresentation(this.element));
        return result;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntegerAttribute other = (BigIntegerAttribute)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }

    public String toString() {
        return this.element.toString();
    }

    @Override
    public boolean isFulfilled(Collection<? extends PolicyFact> facts) {
        return facts.contains(this);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }
}

