/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.common.plaintexts;

import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class GroupElementPlainText
implements PlainText,
UniqueByteRepresentable {
    @UniqueByteRepresented
    private final GroupElement p;

    public GroupElementPlainText(GroupElement elem) {
        this.p = elem;
    }

    public GroupElementPlainText(Representation repr, Group baseGroup) {
        this.p = baseGroup.restoreElement(repr);
    }

    public GroupElement get() {
        return this.p;
    }

    public Representation getRepresentation() {
        return this.p.getRepresentation();
    }

    public String toString() {
        return this.getRepresentation().toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.p);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupElementPlainText other = (GroupElementPlainText)obj;
        return Objects.equals(this.p, other.p);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }
}

