/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.sym.streaming.aes;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.SequenceInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.utils.StreamUtil;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.StreamingEncryptionScheme;
import org.cryptimeleon.craco.enc.SymmetricKey;
import org.cryptimeleon.craco.enc.sym.streaming.aes.SymmetricOutputstream;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.Representation;

abstract class AbstractStreamingSymmetricScheme
implements StreamingEncryptionScheme {
    private static final String INVALID_CT = "Not a valid cipher text for this scheme";
    private static final String INVALID_PT = "Not a valid plain text for this scheme";
    private static final String IO_IV = "Unable to read the IV from stream";
    private static final String INVALID_SYMMETRIC_KEY = "Not a valid symmetric key for this scheme";
    private static final String ENC_INVALID_TRANSFORMATION = "The encryption failed because the used transformation  is invalid.";
    private static final String UNQUALIFIED_KEY_LENGTH = "The given key-length is not valid for this AES instance";
    private static final String ENC_INVALID_KEY = "The encryption failed because the used key is invalid.";
    private static final String DEC_INVALID_TRANSFORMATION = "The decryption failed because the used transformation  is invalid.";
    private static final String DEC_INVALID_KEY = "The decryption failed because the used key is invalid.";
    private final int symmetricKeyLength;
    private final int initialVectorLength;
    protected byte[] initialVector;
    private final String transformation;

    public AbstractStreamingSymmetricScheme(String transformation, int initialVectorLength) {
        this(transformation, initialVectorLength, 128);
    }

    public AbstractStreamingSymmetricScheme(String transformation, int initialVectorLength, int symmetricKeyLength) {
        this.transformation = transformation;
        this.initialVectorLength = initialVectorLength;
        this.initialVector = new byte[initialVectorLength / 8];
        this.symmetricKeyLength = symmetricKeyLength;
    }

    public abstract void initCipher(Cipher var1, ByteArrayImplementation var2, int var3) throws InvalidAlgorithmParameterException, InvalidKeyException;

    @Override
    public InputStream encrypt(InputStream in, EncryptionKey publicKey) throws IOException {
        if (!(publicKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_SYMMETRIC_KEY);
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)publicKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        this.createRandomIV();
        try {
            ByteArrayInputStream ivStream = new ByteArrayInputStream(this.initialVector);
            Cipher cipher = Cipher.getInstance(this.transformation);
            this.initCipher(cipher, symmetricKey, 1);
            CipherInputStream cis = new CipherInputStream(in, cipher);
            return new SequenceInputStream(ivStream, cis);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(ENC_INVALID_TRANSFORMATION, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(ENC_INVALID_KEY, e);
        }
    }

    @Override
    public InputStream decrypt(InputStream in, DecryptionKey privateKey) throws IOException {
        if (!(privateKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_SYMMETRIC_KEY);
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)privateKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        try {
            int amount = in.read(this.initialVector, 0, this.initialVectorLength / 8);
            if (amount != this.initialVectorLength / 8) {
                throw new IllegalArgumentException(IO_IV);
            }
            Cipher cipher = Cipher.getInstance(this.transformation);
            this.initCipher(cipher, symmetricKey, 2);
            return new CipherInputStream(in, cipher);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(DEC_INVALID_TRANSFORMATION, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(DEC_INVALID_KEY, e);
        }
    }

    protected static ByteArrayImplementation updateKeyToLength(ByteArrayImplementation symmetricKey, int symmetricKeyLength) {
        if (symmetricKey.length() * 8 == symmetricKeyLength) {
            return symmetricKey;
        }
        if (symmetricKey.length() * 8 >= symmetricKeyLength) {
            byte[] keyData = new byte[symmetricKeyLength / 8];
            System.arraycopy(symmetricKey.getData(), 0, keyData, 0, symmetricKeyLength / 8);
            ByteArrayImplementation updatedSymmetricKey = new ByteArrayImplementation(keyData);
            return updatedSymmetricKey;
        }
        throw new IllegalArgumentException(UNQUALIFIED_KEY_LENGTH);
    }

    @Override
    public OutputStream createEncryptor(OutputStream out, EncryptionKey publicKey) throws IOException {
        if (!(publicKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_SYMMETRIC_KEY);
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)publicKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        this.createRandomIV();
        out.write(this.initialVector);
        try {
            Cipher cipher = Cipher.getInstance(this.transformation);
            this.initCipher(cipher, symmetricKey, 1);
            return new CipherOutputStream(out, cipher);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalArgumentException(ENC_INVALID_TRANSFORMATION, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(ENC_INVALID_KEY, e);
        }
    }

    @Override
    public OutputStream createDecryptor(OutputStream out, DecryptionKey privateKey) throws IOException {
        if (!(privateKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_SYMMETRIC_KEY);
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)privateKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        return new StreamingOutputstream(symmetricKey, out);
    }

    @Override
    public void encrypt(InputStream plainTextIn, OutputStream cipherTextOut, EncryptionKey publicKey) throws IOException {
        if (!(publicKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_SYMMETRIC_KEY);
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)publicKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        this.createRandomIV();
        cipherTextOut.write(this.initialVector);
        this.streamHelper(plainTextIn, cipherTextOut, symmetricKey, 1);
    }

    @Override
    public void decrypt(InputStream cipherTextIn, OutputStream plainTextOut, DecryptionKey privateKey) throws IOException {
        if (!(privateKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_SYMMETRIC_KEY);
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)privateKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        int amount = cipherTextIn.read(this.initialVector, 0, this.initialVectorLength / 8);
        if (amount != this.initialVectorLength / 8) {
            throw new IllegalArgumentException(IO_IV);
        }
        this.streamHelper(cipherTextIn, plainTextOut, symmetricKey, 2);
    }

    @Override
    public CipherText encrypt(PlainText plainText, EncryptionKey publicKey) {
        if (!(plainText instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_PT);
        }
        ByteArrayImplementation pt = (ByteArrayImplementation)plainText;
        ByteArrayInputStream plainBytesIn = new ByteArrayInputStream(pt.getData());
        BufferedInputStream plainIn = new BufferedInputStream(plainBytesIn);
        ByteArrayOutputStream cipherBytesOut = new ByteArrayOutputStream();
        BufferedOutputStream cipherOut = new BufferedOutputStream(cipherBytesOut);
        try {
            this.encrypt(plainIn, cipherOut, publicKey);
            ((InputStream)plainIn).close();
            ((OutputStream)cipherOut).flush();
            ((OutputStream)cipherOut).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayImplementation(cipherBytesOut.toByteArray());
    }

    @Override
    public PlainText decrypt(CipherText cipherText, DecryptionKey privateKey) {
        if (!(cipherText instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_CT);
        }
        ByteArrayImplementation ct = (ByteArrayImplementation)cipherText;
        ByteArrayInputStream cipherBytesIn = new ByteArrayInputStream(ct.getData());
        BufferedInputStream cipherIn = new BufferedInputStream(cipherBytesIn);
        ByteArrayOutputStream plainBytesOut = new ByteArrayOutputStream();
        BufferedOutputStream plainOut = new BufferedOutputStream(plainBytesOut);
        try {
            this.decrypt(cipherIn, plainOut, privateKey);
            ((InputStream)cipherIn).close();
            ((OutputStream)plainOut).flush();
            ((OutputStream)plainOut).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayImplementation(plainBytesOut.toByteArray());
    }

    private void streamHelper(InputStream inputStream, OutputStream outputStream, SymmetricKey key, int mode) throws IOException {
        if (!(key instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException(INVALID_SYMMETRIC_KEY);
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)key;
        CipherInputStream cipherIn = null;
        PipedInputStream pipedIn = null;
        PipedOutputStream pipedOut = null;
        try {
            Cipher cipher = Cipher.getInstance(this.transformation);
            this.initCipher(cipher, symmetricKey, mode);
            pipedIn = new PipedInputStream();
            pipedOut = new PipedOutputStream();
            pipedOut.connect(pipedIn);
            StreamUtil.copyAsync(inputStream, pipedOut);
            cipherIn = new CipherInputStream(pipedIn, cipher);
            byte[] readByte = new byte[8];
            int length = cipherIn.read(readByte);
            while (length != -1) {
                outputStream.write(readByte, 0, length);
                length = cipherIn.read(readByte);
            }
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            if (mode == 1) {
                throw new IllegalArgumentException(ENC_INVALID_TRANSFORMATION, e);
            }
            throw new IllegalArgumentException(DEC_INVALID_TRANSFORMATION, e);
        }
        catch (InvalidKeyException e) {
            if (mode == 2) {
                throw new IllegalArgumentException(DEC_INVALID_KEY, e);
            }
            throw new IllegalArgumentException(ENC_INVALID_KEY, e);
        }
        finally {
            if (cipherIn != null) {
                cipherIn.close();
            }
            if (pipedIn != null) {
                pipedIn.close();
            }
            if (pipedOut != null) {
                pipedOut.close();
            }
        }
    }

    private void createRandomIV() {
        this.initialVector = RandomGenerator.getRandomBytes((int)(this.initialVectorLength / 8));
    }

    public SymmetricKey generateSymmetricKey() {
        return new ByteArrayImplementation(RandomGenerator.getRandomBytes((int)(this.symmetricKeyLength / 8)));
    }

    @Override
    public CipherText restoreCipherText(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    @Override
    public DecryptionKey restoreDecryptionKey(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    @Override
    public EncryptionKey restoreEncryptionKey(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    public Representation getRepresentation() {
        return new BigIntegerRepresentation((long)this.symmetricKeyLength);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.initialVector);
        result = 31 * result + (this.transformation == null ? 0 : this.transformation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStreamingSymmetricScheme other = (AbstractStreamingSymmetricScheme)obj;
        if (!Arrays.equals(this.initialVector, other.initialVector)) {
            return false;
        }
        return !(this.transformation == null ? other.transformation != null : !this.transformation.equals(other.transformation));
    }

    class StreamingOutputstream
    extends SymmetricOutputstream {
        private ByteArrayImplementation symmetricKey;

        public StreamingOutputstream(ByteArrayImplementation symmetricKey, OutputStream out) {
            super(out, AbstractStreamingSymmetricScheme.this.initialVectorLength);
            this.symmetricKey = symmetricKey;
        }

        @Override
        protected void setupOutputStream() {
            try {
                Cipher cipher = Cipher.getInstance(AbstractStreamingSymmetricScheme.this.transformation);
                AbstractStreamingSymmetricScheme.this.initCipher(cipher, this.symmetricKey, 2);
                this.decryptedOut = new CipherOutputStream(this.out, cipher);
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IllegalArgumentException(AbstractStreamingSymmetricScheme.DEC_INVALID_TRANSFORMATION, e);
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(AbstractStreamingSymmetricScheme.DEC_INVALID_KEY, e);
            }
        }

        @Override
        protected void setIV(int index, byte b) {
            AbstractStreamingSymmetricScheme.this.initialVector[index] = b;
        }
    }
}

