/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.enc.sym.streaming.aes;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.cryptimeleon.craco.common.ByteArrayImplementation;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.StreamingEncryptionScheme;
import org.cryptimeleon.craco.enc.SymmetricKey;
import org.cryptimeleon.craco.enc.sym.streaming.aes.AbstractStreamingSymmetricScheme;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;

public class StreamingGCMAESPacketMode
implements StreamingEncryptionScheme {
    public static final int DEFAULT_PACKET_SIZE = 5120;
    public static final int DEFAULT_KEY_SIZE = 128;
    private final int symmetricKeyLength;
    private final int initialVectorLength = 96;
    private final int tagLength = 128;
    private byte[] initialVector = new byte[12];
    private final String transformation = "AES/GCM/NoPadding";
    private final int packetSize;

    public StreamingGCMAESPacketMode(Representation repr) {
        this.packetSize = repr.obj().get("packetSize").bigInt().getInt();
        this.symmetricKeyLength = repr.obj().get("keySize").bigInt().getInt();
    }

    public StreamingGCMAESPacketMode(int packetSize, int symmetricKeyLength) {
        this.packetSize = packetSize;
        this.symmetricKeyLength = symmetricKeyLength;
    }

    public StreamingGCMAESPacketMode(int packetSize) {
        this(packetSize, 128);
    }

    public StreamingGCMAESPacketMode() {
        this(5120, 128);
    }

    @Override
    public CipherText encrypt(PlainText plainText, EncryptionKey publicKey) {
        if (!(plainText instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException("Not a valid plain text for this scheme");
        }
        ByteArrayImplementation pt = (ByteArrayImplementation)plainText;
        ByteArrayInputStream plainBytesIn = new ByteArrayInputStream(pt.getData());
        BufferedInputStream plainIn = new BufferedInputStream(plainBytesIn);
        ByteArrayOutputStream cipherBytesOut = new ByteArrayOutputStream();
        BufferedOutputStream cipherOut = new BufferedOutputStream(cipherBytesOut);
        try {
            this.encrypt(plainIn, cipherOut, publicKey);
            ((InputStream)plainIn).close();
            ((OutputStream)cipherOut).flush();
            ((OutputStream)cipherOut).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayImplementation(cipherBytesOut.toByteArray());
    }

    @Override
    public PlainText decrypt(CipherText cipherText, DecryptionKey privateKey) {
        if (!(cipherText instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException("Not a valid cipher text for this scheme");
        }
        ByteArrayImplementation ct = (ByteArrayImplementation)cipherText;
        ByteArrayInputStream cipherBytesIn = new ByteArrayInputStream(ct.getData());
        BufferedInputStream cipherIn = new BufferedInputStream(cipherBytesIn);
        ByteArrayOutputStream plainBytesOut = new ByteArrayOutputStream();
        BufferedOutputStream plainOut = new BufferedOutputStream(plainBytesOut);
        try {
            this.decrypt(cipherIn, plainOut, privateKey);
            ((InputStream)cipherIn).close();
            ((OutputStream)plainOut).flush();
            ((OutputStream)plainOut).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayImplementation(plainBytesOut.toByteArray());
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    @Override
    public CipherText restoreCipherText(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    @Override
    public EncryptionKey restoreEncryptionKey(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    @Override
    public DecryptionKey restoreDecryptionKey(Representation repr) {
        return new ByteArrayImplementation(repr);
    }

    public Representation getRepresentation() {
        ObjectRepresentation toReturn = new ObjectRepresentation();
        toReturn.put("packetSize", (Representation)new BigIntegerRepresentation((long)this.packetSize));
        toReturn.put("keySize", (Representation)new BigIntegerRepresentation((long)this.symmetricKeyLength));
        return toReturn;
    }

    @Override
    public InputStream encrypt(final InputStream in, EncryptionKey publicKey) throws IOException {
        Cipher cipher;
        if (!(publicKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException("Not a valid symmetric key for this scheme");
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)publicKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        try {
            cipher = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e1) {
            throw new RuntimeException(e1);
        }
        final SecretKeySpec keySpec = new SecretKeySpec(symmetricKey.getData(), "AES");
        return new InputStream(){
            byte[] bufferedCipherText;
            int bufferedCipherTextSize = 0;
            int bufferedCipherTextOffset = 0;
            int initialVectorLengthInBytes = 12;
            int byteOffset = 0;
            BigInteger packetRound = BigInteger.valueOf(0L);
            BigInteger initV;

            @Override
            public int read() throws IOException {
                int read;
                if (this.byteOffset == 0) {
                    StreamingGCMAESPacketMode.this.createRandomIV();
                    this.initV = new BigInteger(StreamingGCMAESPacketMode.this.initialVector);
                }
                if (this.byteOffset < this.initialVectorLengthInBytes) {
                    ++this.byteOffset;
                    return Byte.toUnsignedInt(StreamingGCMAESPacketMode.this.initialVector[this.byteOffset++]);
                }
                if (this.bufferedCipherTextOffset == this.bufferedCipherTextSize && (read = this.bufferPacket()) == -1) {
                    return -1;
                }
                byte toReturn = this.bufferedCipherText[this.bufferedCipherTextOffset];
                ++this.bufferedCipherTextOffset;
                return Byte.toUnsignedInt(toReturn);
            }

            public int bufferPacket() {
                try {
                    byte[] plainText = new byte[StreamingGCMAESPacketMode.this.packetSize];
                    int read = in.read(plainText);
                    if (read == -1) {
                        return -1;
                    }
                    if (read != StreamingGCMAESPacketMode.this.packetSize) {
                        byte[] tempPlaintext = new byte[StreamingGCMAESPacketMode.this.packetSize];
                        System.arraycopy(plainText, 0, tempPlaintext, 0, read);
                        plainText = new byte[read];
                        System.arraycopy(tempPlaintext, 0, plainText, 0, read);
                    }
                    BigInteger initV_i = this.initV.add(this.packetRound);
                    byte[] initialVector_i = initV_i.toByteArray();
                    GCMParameterSpec gcmSpec = new GCMParameterSpec(128, initialVector_i);
                    cipher.init(1, (Key)keySpec, gcmSpec);
                    byte[] packetRoundBytes = this.packetRound.toByteArray();
                    byte[] aad = new byte[StreamingGCMAESPacketMode.this.initialVector.length + packetRoundBytes.length];
                    System.arraycopy(StreamingGCMAESPacketMode.this.initialVector, 0, aad, 0, StreamingGCMAESPacketMode.this.initialVector.length);
                    System.arraycopy(packetRoundBytes, 0, aad, StreamingGCMAESPacketMode.this.initialVector.length, packetRoundBytes.length);
                    cipher.updateAAD(aad);
                    this.bufferedCipherText = cipher.doFinal(plainText);
                    this.bufferedCipherTextSize = this.bufferedCipherText.length;
                    this.bufferedCipherTextOffset = 0;
                    this.packetRound = this.packetRound.add(BigInteger.ONE);
                    return this.bufferedCipherTextSize;
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.byteOffset < this.initialVectorLengthInBytes) {
                    int remainingIVBytes;
                    if (this.byteOffset == 0) {
                        StreamingGCMAESPacketMode.this.createRandomIV();
                        this.initV = new BigInteger(StreamingGCMAESPacketMode.this.initialVector);
                    }
                    if ((remainingIVBytes = this.initialVectorLengthInBytes - this.byteOffset) < len) {
                        System.arraycopy(StreamingGCMAESPacketMode.this.initialVector, this.byteOffset, b, off, remainingIVBytes);
                        this.byteOffset += remainingIVBytes;
                        int read = this.read(b, off + remainingIVBytes, len - remainingIVBytes);
                        if (read == -1) {
                            return remainingIVBytes;
                        }
                        return remainingIVBytes + read;
                    }
                    System.arraycopy(StreamingGCMAESPacketMode.this.initialVector, this.byteOffset, b, off, len);
                    this.byteOffset += len;
                    return len;
                }
                int remainingBytes = this.bufferedCipherTextSize - this.bufferedCipherTextOffset;
                if (remainingBytes < len) {
                    if (remainingBytes > 0) {
                        System.arraycopy(this.bufferedCipherText, this.bufferedCipherTextOffset, b, off, remainingBytes);
                        this.bufferedCipherTextOffset += remainingBytes;
                    }
                    int read = this.bufferPacket();
                    if (remainingBytes == 0 && read == -1) {
                        return -1;
                    }
                    if (read == -1) {
                        return remainingBytes;
                    }
                    return remainingBytes + this.read(b, off + remainingBytes, len - remainingBytes);
                }
                System.arraycopy(this.bufferedCipherText, this.bufferedCipherTextOffset, b, off, len);
                this.bufferedCipherTextOffset += len;
                return len;
            }
        };
    }

    @Override
    public OutputStream createEncryptor(final OutputStream out, EncryptionKey publicKey) throws IOException {
        Cipher cipher;
        if (!(publicKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException("Not a valid symmetric key for this scheme");
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)publicKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        this.createRandomIV();
        out.write(this.initialVector, 0, this.initialVector.length);
        final SecretKeySpec keySpec = new SecretKeySpec(symmetricKey.getData(), "AES");
        try {
            cipher = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        OutputStream toReturn = new OutputStream(){
            int bufferedPlainTextOffset = 0;
            int bufferedPlainTextSize = StreamingGCMAESPacketMode.access$200(StreamingGCMAESPacketMode.this);
            byte[] bufferedData = new byte[StreamingGCMAESPacketMode.access$200(StreamingGCMAESPacketMode.this)];
            BigInteger packetRound = BigInteger.valueOf(0L);
            BigInteger initV = new BigInteger(StreamingGCMAESPacketMode.access$100(StreamingGCMAESPacketMode.this));

            @Override
            public void write(int b) throws IOException {
                int freeData = this.bufferedPlainTextSize - this.bufferedPlainTextOffset;
                if (freeData > 0) {
                    this.bufferedData[this.bufferedPlainTextOffset] = (byte)b;
                    ++this.bufferedPlainTextOffset;
                } else {
                    this.writePacket();
                    this.write(b);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                int freeData = this.bufferedPlainTextSize - this.bufferedPlainTextOffset;
                if (freeData < len) {
                    if (freeData > 0) {
                        System.arraycopy(b, off, this.bufferedData, this.bufferedPlainTextOffset, freeData);
                    }
                    this.bufferedPlainTextOffset += freeData;
                    this.writePacket();
                    this.write(b, off + freeData, len - freeData);
                } else {
                    System.arraycopy(b, off, this.bufferedData, this.bufferedPlainTextOffset, len);
                    this.bufferedPlainTextOffset += len;
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.bufferedPlainTextOffset > 0) {
                    this.writePacket();
                }
                out.close();
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                if (this.bufferedPlainTextOffset > 0) {
                    this.writePacket();
                }
                out.flush();
            }

            private void writePacket() {
                BigInteger initV_i = this.initV.add(this.packetRound);
                byte[] initialVector_i = initV_i.toByteArray();
                GCMParameterSpec gcmSpec = new GCMParameterSpec(128, initialVector_i);
                try {
                    if (this.bufferedPlainTextOffset != this.bufferedPlainTextSize) {
                        byte[] tempData = new byte[this.bufferedPlainTextOffset];
                        System.arraycopy(this.bufferedData, 0, tempData, 0, this.bufferedPlainTextOffset);
                        this.bufferedData = new byte[this.bufferedPlainTextOffset];
                        System.arraycopy(tempData, 0, this.bufferedData, 0, this.bufferedPlainTextOffset);
                    }
                    cipher.init(1, (Key)keySpec, gcmSpec);
                    byte[] packetRoundBytes = this.packetRound.toByteArray();
                    byte[] aad = new byte[StreamingGCMAESPacketMode.this.initialVector.length + packetRoundBytes.length];
                    System.arraycopy(StreamingGCMAESPacketMode.this.initialVector, 0, aad, 0, StreamingGCMAESPacketMode.this.initialVector.length);
                    System.arraycopy(packetRoundBytes, 0, aad, StreamingGCMAESPacketMode.this.initialVector.length, packetRoundBytes.length);
                    cipher.updateAAD(aad);
                    byte[] cipherText = cipher.doFinal(this.bufferedData);
                    out.write(cipherText, 0, cipherText.length);
                    this.packetRound = this.packetRound.add(BigInteger.ONE);
                    this.bufferedData = new byte[StreamingGCMAESPacketMode.this.packetSize];
                    this.bufferedPlainTextSize = StreamingGCMAESPacketMode.this.packetSize;
                    this.bufferedPlainTextOffset = 0;
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return toReturn;
    }

    @Override
    public InputStream decrypt(final InputStream in, DecryptionKey privateKey) throws IOException {
        Cipher cipher;
        if (!(privateKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException("Not a valid symmetric key for this scheme");
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)privateKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        in.read(this.initialVector);
        try {
            cipher = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e1) {
            throw new RuntimeException(e1);
        }
        final SecretKeySpec keySpec = new SecretKeySpec(symmetricKey.getData(), "AES");
        return new InputStream(){
            byte[] bufferedPlainText;
            int bufferedPlainTextSize = 0;
            int bufferedPlainTextOffset = 0;
            int tagLengthInBytes = 16;
            int cipherPacketSize = StreamingGCMAESPacketMode.access$200(StreamingGCMAESPacketMode.this) + this.tagLengthInBytes;
            int byteOffset = 0;
            BigInteger packetRound = BigInteger.valueOf(0L);
            BigInteger initV = new BigInteger(StreamingGCMAESPacketMode.access$100(StreamingGCMAESPacketMode.this));

            @Override
            public int read() throws IOException {
                int read;
                if (this.bufferedPlainTextOffset == this.bufferedPlainTextSize && (read = this.bufferPacket()) == -1) {
                    return -1;
                }
                byte toReturn = this.bufferedPlainText[this.bufferedPlainTextOffset];
                ++this.bufferedPlainTextOffset;
                return Byte.toUnsignedInt(toReturn);
            }

            public int bufferPacket() {
                try {
                    byte[] cipherText = new byte[this.cipherPacketSize];
                    int read = in.read(cipherText);
                    if (read == -1) {
                        return -1;
                    }
                    if (read != StreamingGCMAESPacketMode.this.packetSize) {
                        byte[] tempPlaintext = new byte[this.cipherPacketSize];
                        System.arraycopy(cipherText, 0, tempPlaintext, 0, read);
                        cipherText = new byte[read];
                        System.arraycopy(tempPlaintext, 0, cipherText, 0, read);
                    }
                    BigInteger initV_i = this.initV.add(this.packetRound);
                    byte[] initialVector_i = initV_i.toByteArray();
                    GCMParameterSpec gcmSpec = new GCMParameterSpec(128, initialVector_i);
                    cipher.init(2, (Key)keySpec, gcmSpec);
                    byte[] packetRoundBytes = this.packetRound.toByteArray();
                    byte[] aad = new byte[StreamingGCMAESPacketMode.this.initialVector.length + packetRoundBytes.length];
                    System.arraycopy(StreamingGCMAESPacketMode.this.initialVector, 0, aad, 0, StreamingGCMAESPacketMode.this.initialVector.length);
                    System.arraycopy(packetRoundBytes, 0, aad, StreamingGCMAESPacketMode.this.initialVector.length, packetRoundBytes.length);
                    cipher.updateAAD(aad);
                    this.bufferedPlainText = cipher.doFinal(cipherText);
                    this.bufferedPlainTextSize = this.bufferedPlainText.length;
                    this.bufferedPlainTextOffset = 0;
                    this.packetRound = this.packetRound.add(BigInteger.ONE);
                    return this.bufferedPlainTextSize;
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int remainingBytes = this.bufferedPlainTextSize - this.bufferedPlainTextOffset;
                if (remainingBytes < len) {
                    if (remainingBytes > 0) {
                        System.arraycopy(this.bufferedPlainText, this.bufferedPlainTextOffset, b, off, remainingBytes);
                        this.bufferedPlainTextOffset += remainingBytes;
                    }
                    int read = this.bufferPacket();
                    if (remainingBytes == 0 && read == -1) {
                        return -1;
                    }
                    if (read == -1) {
                        return remainingBytes;
                    }
                    return remainingBytes + this.read(b, off + remainingBytes, len - remainingBytes);
                }
                System.arraycopy(this.bufferedPlainText, this.bufferedPlainTextOffset, b, off, len);
                this.bufferedPlainTextOffset += len;
                return len;
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }
        };
    }

    @Override
    public OutputStream createDecryptor(final OutputStream out, DecryptionKey privateKey) throws IOException {
        Cipher cipher;
        if (!(privateKey instanceof ByteArrayImplementation)) {
            throw new IllegalArgumentException("Not a valid symmetric key for this scheme");
        }
        ByteArrayImplementation symmetricKey = (ByteArrayImplementation)privateKey;
        symmetricKey = AbstractStreamingSymmetricScheme.updateKeyToLength(symmetricKey, this.symmetricKeyLength);
        final SecretKeySpec keySpec = new SecretKeySpec(symmetricKey.getData(), "AES");
        try {
            cipher = Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e1) {
            throw new RuntimeException(e1);
        }
        return new OutputStream(){
            int byteOffset = 0;
            final int ivLengthInBytes = StreamingGCMAESPacketMode.access$100(StreamingGCMAESPacketMode.this).length;
            final int tagLengthInBytes = 16;
            final int cipherPacketSize = StreamingGCMAESPacketMode.access$200(StreamingGCMAESPacketMode.this) + 16;
            int bufferedDataOffset = 0;
            byte[] bufferedData = new byte[this.cipherPacketSize];
            BigInteger packetRound = BigInteger.valueOf(0L);
            BigInteger initV;

            @Override
            public void write(int b) throws IOException {
                if (this.byteOffset < this.ivLengthInBytes) {
                    ((StreamingGCMAESPacketMode)StreamingGCMAESPacketMode.this).initialVector[this.byteOffset] = (byte)b;
                    if (this.byteOffset == this.ivLengthInBytes - 1) {
                        this.initV = new BigInteger(StreamingGCMAESPacketMode.this.initialVector);
                    }
                    ++this.byteOffset;
                } else {
                    this.bufferedData[this.bufferedDataOffset] = (byte)b;
                    ++this.bufferedDataOffset;
                    if (this.bufferedDataOffset == this.cipherPacketSize) {
                        this.writePacket();
                    }
                }
            }

            private void writePacket() {
                BigInteger initV_i = this.initV.add(this.packetRound);
                byte[] initialVector_i = initV_i.toByteArray();
                GCMParameterSpec gcmSpec = new GCMParameterSpec(128, initialVector_i);
                try {
                    cipher.init(2, (Key)keySpec, gcmSpec);
                    if (this.bufferedData.length != this.bufferedDataOffset) {
                        byte[] tempCiphertext = new byte[this.bufferedDataOffset];
                        System.arraycopy(this.bufferedData, 0, tempCiphertext, 0, this.bufferedDataOffset);
                        this.bufferedData = new byte[this.bufferedDataOffset];
                        System.arraycopy(tempCiphertext, 0, this.bufferedData, 0, this.bufferedDataOffset);
                    }
                    byte[] packetRoundBytes = this.packetRound.toByteArray();
                    byte[] aad = new byte[StreamingGCMAESPacketMode.this.initialVector.length + packetRoundBytes.length];
                    System.arraycopy(StreamingGCMAESPacketMode.this.initialVector, 0, aad, 0, StreamingGCMAESPacketMode.this.initialVector.length);
                    System.arraycopy(packetRoundBytes, 0, aad, StreamingGCMAESPacketMode.this.initialVector.length, packetRoundBytes.length);
                    cipher.updateAAD(aad);
                    byte[] plainText = cipher.doFinal(this.bufferedData);
                    out.write(plainText, 0, this.bufferedDataOffset - 16);
                    this.bufferedData = new byte[this.cipherPacketSize];
                    this.packetRound = this.packetRound.add(BigInteger.ONE);
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                    throw new RuntimeException(e);
                }
                this.bufferedDataOffset = 0;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.byteOffset < this.ivLengthInBytes) {
                    int remainingIVBytes = this.ivLengthInBytes - this.byteOffset;
                    if (remainingIVBytes < len) {
                        for (int i = off; i < off + remainingIVBytes; ++i) {
                            this.write(b[i]);
                        }
                        this.write(b, off + remainingIVBytes, len - remainingIVBytes);
                    } else {
                        for (int i = off; i < off + len; ++i) {
                            this.write(b[i]);
                        }
                    }
                } else {
                    int freeData = this.bufferedData.length - this.bufferedDataOffset;
                    if (len < freeData) {
                        if (len > 0) {
                            System.arraycopy(b, off, this.bufferedData, this.bufferedDataOffset, len);
                        }
                        this.bufferedDataOffset += len;
                    } else {
                        System.arraycopy(b, off, this.bufferedData, this.bufferedDataOffset, freeData);
                        this.bufferedDataOffset += freeData;
                        this.writePacket();
                        this.write(b, off + freeData, len - freeData);
                    }
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void close() throws IOException {
                super.close();
                if (this.bufferedDataOffset > 0) {
                    this.writePacket();
                }
                out.close();
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                if (this.bufferedDataOffset > 0) {
                    this.writePacket();
                }
                out.flush();
            }
        };
    }

    private void createRandomIV() {
        this.initialVector = RandomGenerator.getRandomBytes((int)12);
    }

    public SymmetricKey generateSymmetricKey() {
        return new ByteArrayImplementation(RandomGenerator.getRandomBytes((int)(this.symmetricKeyLength / 8)));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.initialVector);
        result = 31 * result + 96;
        result = 31 * result + this.packetSize;
        result = 31 * result + this.symmetricKeyLength;
        result = 31 * result + 128;
        result = 31 * result + ("AES/GCM/NoPadding" == null ? 0 : "AES/GCM/NoPadding".hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamingGCMAESPacketMode other = (StreamingGCMAESPacketMode)obj;
        if (!Arrays.equals(this.initialVector, other.initialVector)) {
            return false;
        }
        if (96 != other.initialVectorLength) {
            return false;
        }
        if (this.packetSize != other.packetSize) {
            return false;
        }
        if (this.symmetricKeyLength != other.symmetricKeyLength) {
            return false;
        }
        if (128 != other.tagLength) {
            return false;
        }
        return !("AES/GCM/NoPadding" == null ? other.transformation != null : !"AES/GCM/NoPadding".equals(other.transformation));
    }
}

