/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.kem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.enc.CipherText;
import org.cryptimeleon.craco.enc.DecryptionKey;
import org.cryptimeleon.craco.enc.EncryptionKey;
import org.cryptimeleon.craco.enc.StreamingEncryptionScheme;
import org.cryptimeleon.craco.enc.SymmetricKey;
import org.cryptimeleon.craco.kem.KeyEncapsulationMechanism;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.serialization.converter.JSONConverter;

public class StreamingHybridEncryptionScheme
implements StreamingEncryptionScheme {
    @Represented
    private StreamingEncryptionScheme symmetricScheme;
    @Represented
    private KeyEncapsulationMechanism<SymmetricKey> kem;

    public StreamingHybridEncryptionScheme(StreamingEncryptionScheme symmetricScheme, KeyEncapsulationMechanism<SymmetricKey> kem2) {
        this.symmetricScheme = symmetricScheme;
        this.kem = kem2;
    }

    public StreamingHybridEncryptionScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    @Override
    public CipherText encrypt(PlainText plainText, EncryptionKey publicKey) {
        KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> keyAndCiphertext = this.kem.encaps(publicKey);
        return new HybridCipherText(this.symmetricScheme.encrypt(plainText, (EncryptionKey)keyAndCiphertext.key), keyAndCiphertext.encapsulatedKey);
    }

    @Override
    public PlainText decrypt(CipherText cipherText, DecryptionKey privateKey) {
        SymmetricKey symmetricKey = this.kem.decaps(((HybridCipherText)cipherText).encapsulatedKey, privateKey);
        return this.symmetricScheme.decrypt(((HybridCipherText)cipherText).ciphertext, (DecryptionKey)symmetricKey);
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        return this.symmetricScheme.restorePlainText(repr);
    }

    @Override
    public CipherText restoreCipherText(Representation repr) {
        return new HybridCipherText(repr, this.symmetricScheme, this.kem);
    }

    @Override
    public EncryptionKey restoreEncryptionKey(Representation repr) {
        return this.kem.restoreEncapsulationKey(repr);
    }

    @Override
    public DecryptionKey restoreDecryptionKey(Representation repr) {
        return this.kem.restoreDecapsulationKey(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    @Override
    public InputStream encrypt(InputStream in, EncryptionKey publicKey) throws IOException {
        KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> keyAndCiphertext = this.kem.encaps(publicKey);
        byte[] encapsulatedKey = new JSONConverter().serialize(keyAndCiphertext.encapsulatedKey.getRepresentation()).getBytes(StandardCharsets.UTF_8);
        byte[] keyLenBytes = ByteBuffer.allocate(4).putInt(encapsulatedKey.length).array();
        return new SequenceInputStream(new ByteArrayInputStream(keyLenBytes), new SequenceInputStream(new ByteArrayInputStream(encapsulatedKey), this.symmetricScheme.encrypt(in, (EncryptionKey)keyAndCiphertext.key)));
    }

    @Override
    public OutputStream createEncryptor(OutputStream out, EncryptionKey publicKey) throws IOException {
        KeyEncapsulationMechanism.KeyAndCiphertext<SymmetricKey> keyAndCiphertext = this.kem.encaps(publicKey);
        byte[] encapsulatedKey = new JSONConverter().serialize(keyAndCiphertext.encapsulatedKey.getRepresentation()).getBytes(StandardCharsets.UTF_8);
        byte[] keyLenBytes = ByteBuffer.allocate(4).putInt(encapsulatedKey.length).array();
        out.write(keyLenBytes);
        out.write(encapsulatedKey);
        return this.symmetricScheme.createEncryptor(out, (EncryptionKey)keyAndCiphertext.key);
    }

    @Override
    public InputStream decrypt(InputStream in, DecryptionKey privateKey) throws IOException {
        byte[] keyLenBytes = new byte[4];
        int triesLeft = 10;
        for (int i = 0; i < 4; ++i) {
            while (in.read(keyLenBytes, i, 1) < 1 && --triesLeft > 0) {
            }
        }
        if (triesLeft == 0) {
            throw new IOException("didn't get keylen data from ciphertext");
        }
        int keyLen = ByteBuffer.wrap(keyLenBytes).getInt();
        byte[] encapsulatedKeyBytes = new byte[keyLen];
        triesLeft = 10;
        for (int i = 0; i < keyLen; ++i) {
            while (in.read(encapsulatedKeyBytes, i, 1) < 1 && --triesLeft > 0) {
            }
        }
        if (triesLeft == 0) {
            throw new IOException("couldn't read encapulated key from ciphertext");
        }
        CipherText encapsulatedKey = this.kem.restoreEncapsulatedKey(new JSONConverter().deserialize(new String(encapsulatedKeyBytes)));
        SymmetricKey symmetricKey = this.kem.decaps(encapsulatedKey, privateKey);
        return this.symmetricScheme.decrypt(in, (DecryptionKey)symmetricKey);
    }

    @Override
    public OutputStream createDecryptor(final OutputStream out, final DecryptionKey privateKey) {
        return new OutputStream(){
            int byteOffset = 0;
            byte[] keyLenBytes = new byte[4];
            int keyLen = 0;
            byte[] encapsulatedKeyBytes = null;
            OutputStream decryptedOut = null;

            @Override
            public void write(int b) throws IOException {
                if (this.byteOffset < 4) {
                    this.keyLenBytes[this.byteOffset] = (byte)b;
                    if (this.byteOffset == 3) {
                        this.keyLen = ByteBuffer.wrap(this.keyLenBytes).getInt();
                        this.encapsulatedKeyBytes = new byte[this.keyLen];
                    }
                } else if (this.byteOffset < 4 + this.keyLen) {
                    this.encapsulatedKeyBytes[this.byteOffset - 4] = (byte)b;
                    if (this.byteOffset == 4 + this.keyLen - 1) {
                        CipherText encapsulatedKey = StreamingHybridEncryptionScheme.this.kem.restoreEncapsulatedKey(new JSONConverter().deserialize(new String(this.encapsulatedKeyBytes)));
                        SymmetricKey symmetricKey = (SymmetricKey)StreamingHybridEncryptionScheme.this.kem.decaps(encapsulatedKey, privateKey);
                        this.decryptedOut = StreamingHybridEncryptionScheme.this.symmetricScheme.createDecryptor(out, symmetricKey);
                    }
                } else {
                    this.decryptedOut.write(b);
                }
                ++this.byteOffset;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.byteOffset < 4 + this.keyLen) {
                    for (int i = off; i < off + len; ++i) {
                        this.write(b[i]);
                    }
                } else {
                    this.decryptedOut.write(b, off, len);
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void flush() throws IOException {
                if (this.decryptedOut != null) {
                    this.decryptedOut.flush();
                }
            }

            @Override
            public void close() throws IOException {
                if (this.decryptedOut != null) {
                    this.decryptedOut.close();
                }
                out.close();
            }
        };
    }

    public KeyEncapsulationMechanism<SymmetricKey> getKeyEncapsulationMechanism() {
        return this.kem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kem == null ? 0 : this.kem.hashCode());
        result = 31 * result + (this.symmetricScheme == null ? 0 : this.symmetricScheme.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamingHybridEncryptionScheme other = (StreamingHybridEncryptionScheme)obj;
        return Objects.equals(this.symmetricScheme, other.symmetricScheme) && Objects.equals(this.kem, other.kem);
    }

    public static class HybridCipherText
    implements CipherText {
        @Represented(restorer="Scheme")
        private CipherText ciphertext;
        @Represented(restorer="Kem")
        private CipherText encapsulatedKey;

        public HybridCipherText(CipherText ciphertext, CipherText encapsulatedKey) {
            this.ciphertext = ciphertext;
            this.encapsulatedKey = encapsulatedKey;
        }

        public HybridCipherText(Representation repr, StreamingEncryptionScheme scheme, KeyEncapsulationMechanism<SymmetricKey> kem) {
            new ReprUtil((Object)this).register((RepresentationRestorer)scheme, "Scheme").register(kem, "Kem").deserialize(repr);
        }

        public Representation getRepresentation() {
            return ReprUtil.serialize((Object)this);
        }
    }
}

