/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.fiatshamir;

import java.util.Objects;
import org.cryptimeleon.craco.protocols.arguments.sigma.Challenge;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;

public class FiatShamirProof
implements Representable {
    public final Representation compressedTranscript;
    public final Challenge challenge;

    public FiatShamirProof(Representation compressedTranscript, Challenge challenge) {
        this.compressedTranscript = compressedTranscript;
        this.challenge = challenge;
    }

    public Representation getRepresentation() {
        ObjectRepresentation repr = new ObjectRepresentation();
        repr.put("transcript", this.compressedTranscript);
        repr.put("challenge", this.challenge.getRepresentation());
        return repr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FiatShamirProof that = (FiatShamirProof)o;
        return Objects.equals(this.compressedTranscript, that.compressedTranscript) && Objects.equals(this.challenge, that.challenge);
    }

    public int hashCode() {
        return Objects.hash(this.compressedTranscript, this.challenge);
    }
}

