/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.cryptimeleon.craco.protocols.arguments.sigma.Announcement;
import org.cryptimeleon.craco.protocols.arguments.sigma.AnnouncementSecret;
import org.cryptimeleon.craco.protocols.arguments.sigma.Response;
import org.cryptimeleon.craco.protocols.arguments.sigma.SigmaProtocolTranscript;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallenge;
import org.cryptimeleon.craco.protocols.arguments.sigma.ZnChallengeSpace;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SchnorrFragment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.SendFirstValue;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrGroupElemVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrGroupElemVariableValue;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableAssignment;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableValue;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableValueList;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrZnVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrZnVariableValue;
import org.cryptimeleon.math.expressions.bool.BoolConstantExpr;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public abstract class SendThenDelegateFragment
implements SchnorrFragment {
    protected abstract ProverSpec provideProverSpec(SchnorrVariableAssignment var1, ProverSpecBuilder var2);

    protected abstract SendFirstValue restoreSendFirstValue(Representation var1);

    protected abstract SendFirstValue simulateSendFirstValue();

    protected abstract SubprotocolSpec provideSubprotocolSpec(SendFirstValue var1, SubprotocolSpecBuilder var2);

    protected abstract BooleanExpression provideAdditionalCheck(SendFirstValue var1);

    @Override
    public AnnouncementSecret generateAnnouncementSecret(SchnorrVariableAssignment externalWitnesses) {
        ProverSpec proverSpec = this.provideProverSpec(externalWitnesses, new ProverSpecBuilder(this));
        Map<String, AnnouncementSecret> subprotocolAnnouncementSecrets = proverSpec.subprotocolSpec.mapSubprotocols((name, subprotocol) -> subprotocol.generateAnnouncementSecret(proverSpec.witnesses.fallbackTo(externalWitnesses)));
        SchnorrVariableValueList randomVariableValues = proverSpec.subprotocolSpec.createRandomVariableAssignment();
        return new SendThenDelegateAnnouncementSecret(randomVariableValues, proverSpec, subprotocolAnnouncementSecrets);
    }

    @Override
    public Announcement generateAnnouncement(SchnorrVariableAssignment externalWitnesses, AnnouncementSecret announcementSecret, SchnorrVariableAssignment externalRandom) {
        SendThenDelegateAnnouncementSecret announcementSecret1 = (SendThenDelegateAnnouncementSecret)announcementSecret;
        Map<String, Announcement> subprotocolAnnouncements = announcementSecret1.subprotocolSpec.mapSubprotocols((name, fragment) -> fragment.generateAnnouncement(announcementSecret1.witnessValues.fallbackTo(externalWitnesses), announcementSecret1.subprotocolAnnouncementSecret.get(name), announcementSecret1.randomVariableValues.fallbackTo(externalRandom)));
        return new SendThenDelegateAnnouncement(announcementSecret1.subprotocolSpec, subprotocolAnnouncements, announcementSecret1.sendFirstValue);
    }

    @Override
    public Response generateResponse(SchnorrVariableAssignment externalWitnesses, AnnouncementSecret announcementSecret, ZnChallenge challenge) {
        SendThenDelegateAnnouncementSecret announcementSecret1 = (SendThenDelegateAnnouncementSecret)announcementSecret;
        WitnessValues witnessValues = announcementSecret1.witnessValues;
        Map<String, Response> subprotocolResponses = announcementSecret1.subprotocolSpec.mapSubprotocols((subprotocolName, subprotocol) -> subprotocol.generateResponse(announcementSecret1.witnessValues.fallbackTo(externalWitnesses), announcementSecret1.subprotocolAnnouncementSecret.get(subprotocolName), challenge));
        SchnorrVariableValueList knowledgeVarResponse = announcementSecret1.subprotocolSpec.createVariableAssignment((name, variable) -> witnessValues.getValue((SchnorrVariable)variable).evalLinear(challenge.getChallenge(), announcementSecret1.randomVariableValues.getValue((SchnorrVariable)variable)));
        return new SendThenDelegateResponse(subprotocolResponses, knowledgeVarResponse);
    }

    @Override
    public BooleanExpression checkTranscript(Announcement announcement, ZnChallenge challenge, Response response, SchnorrVariableAssignment externalResponse) {
        SendFirstValue sendFirstValue = ((SendThenDelegateAnnouncement)announcement).sendFirstValue;
        SubprotocolSpec subprotocolSpec = ((SendThenDelegateAnnouncement)announcement).subprotocolSpec;
        BoolConstantExpr checkResult = BooleanExpression.TRUE;
        Map<String, BooleanExpression> subprotocolChecks = subprotocolSpec.mapSubprotocols((name, subprotocol) -> subprotocol.checkTranscript(((SendThenDelegateAnnouncement)announcement).subprotocolAnnouncements.get(name), challenge, (Response)((SendThenDelegateResponse)response).subprotocolResponses.get(name), ((SendThenDelegateResponse)response).variableResponses.fallbackTo(externalResponse)));
        for (BooleanExpression subprotocolResult : subprotocolChecks.values()) {
            checkResult = checkResult.and(subprotocolResult);
        }
        checkResult = checkResult.and(this.provideAdditionalCheck(sendFirstValue));
        return checkResult;
    }

    @Override
    public SigmaProtocolTranscript generateSimulatedTranscript(ZnChallenge challenge, SchnorrVariableAssignment externalRandomResponse) {
        SendFirstValue sendFirstValue = this.simulateSendFirstValue();
        SubprotocolSpec subprotocolSpec = this.provideSubprotocolSpec(sendFirstValue, new SubprotocolSpecBuilder());
        SchnorrVariableValueList randomResponses = subprotocolSpec.createRandomVariableAssignment();
        Map<String, SigmaProtocolTranscript> subprotocolTranscripts = subprotocolSpec.mapSubprotocols((name, fragment) -> fragment.generateSimulatedTranscript(challenge, randomResponses.fallbackTo(externalRandomResponse)));
        HashMap subprotocolAnnouncements = new HashMap();
        HashMap<String, Response> subprotocolResponses = new HashMap<String, Response>();
        subprotocolTranscripts.forEach((name, transcript) -> {
            subprotocolAnnouncements.put(name, transcript.getAnnouncement());
            subprotocolResponses.put((String)name, transcript.getResponse());
        });
        return new SigmaProtocolTranscript(new SendThenDelegateAnnouncement(subprotocolSpec, subprotocolAnnouncements, sendFirstValue), challenge, new SendThenDelegateResponse(subprotocolResponses, randomResponses));
    }

    @Override
    public Announcement restoreAnnouncement(Representation repr) {
        SendFirstValue sendFirstValue = this.restoreSendFirstValue(repr.list().get(0));
        SubprotocolSpec subprotocolSpec = this.provideSubprotocolSpec(sendFirstValue, new SubprotocolSpecBuilder());
        HashMap<String, Announcement> subprotocolAnnouncements = new HashMap<String, Announcement>();
        List<Map.Entry<String, SchnorrFragment>> subprotocolList = subprotocolSpec.getOrderedListOfSubprotocolsAndNames();
        for (int i = 0; i < subprotocolList.size(); ++i) {
            subprotocolAnnouncements.put(subprotocolList.get(i).getKey(), subprotocolList.get(i).getValue().restoreAnnouncement(repr.list().get(i + 1)));
        }
        return new SendThenDelegateAnnouncement(subprotocolSpec, subprotocolAnnouncements, sendFirstValue);
    }

    @Override
    public Response restoreResponse(Announcement announcement, Representation repr) {
        SubprotocolSpec subprotocolSpec = ((SendThenDelegateAnnouncement)announcement).subprotocolSpec;
        SchnorrVariableValueList variableResponses = new SchnorrVariableValueList(subprotocolSpec.getOrderedListOfVariables(), repr.list().get(0));
        HashMap<String, Response> subprotocolResponses = new HashMap<String, Response>();
        List<Map.Entry<String, SchnorrFragment>> subprotocols = subprotocolSpec.getOrderedListOfSubprotocolsAndNames();
        for (int i = 0; i < subprotocols.size(); ++i) {
            String name = subprotocols.get(i).getKey();
            SchnorrFragment subprotocol = subprotocols.get(i).getValue();
            subprotocolResponses.put(name, subprotocol.restoreResponse(((SendThenDelegateAnnouncement)announcement).subprotocolAnnouncements.get(name), repr.list().get(i + 1)));
        }
        return new SendThenDelegateResponse(subprotocolResponses, variableResponses);
    }

    @Override
    public Representation compressTranscript(Announcement announcement, ZnChallenge challenge, Response response, SchnorrVariableAssignment externalResponse) {
        ListRepresentation result = new ListRepresentation();
        SendThenDelegateAnnouncement announcement1 = (SendThenDelegateAnnouncement)announcement;
        SendThenDelegateResponse response1 = (SendThenDelegateResponse)response;
        result.add(announcement1.sendFirstValue.getRepresentation());
        result.add(response1.variableResponses.getRepresentation());
        announcement1.subprotocolSpec.forEachProtocolOrdered((name, fragment) -> result.add(fragment.compressTranscript(announcement1.subprotocolAnnouncements.get(name), challenge, (Response)response1.subprotocolResponses.get(name), response1.variableResponses.fallbackTo(externalResponse))));
        return result;
    }

    @Override
    public SigmaProtocolTranscript decompressTranscript(Representation compressedTranscript, ZnChallenge challenge, SchnorrVariableAssignment externalResponse) throws IllegalArgumentException {
        SendFirstValue sendFirstValue = this.restoreSendFirstValue(compressedTranscript.list().get(0));
        if (!this.provideAdditionalCheck(sendFirstValue).evaluate().booleanValue()) {
            throw new IllegalArgumentException("Cannot decompress transcript because its sendFirstValue is invalid");
        }
        SubprotocolSpec spec = this.provideSubprotocolSpec(sendFirstValue, new SubprotocolSpecBuilder());
        SchnorrVariableValueList variableResponses = new SchnorrVariableValueList(spec.getOrderedListOfVariables(), compressedTranscript.list().get(1));
        HashMap<String, Announcement> subprotocolAnnouncements = new HashMap<String, Announcement>();
        HashMap<String, Response> subprotocolResponses = new HashMap<String, Response>();
        List<Map.Entry<String, SchnorrFragment>> orderedListOfSubprotocolsAndNames = spec.getOrderedListOfSubprotocolsAndNames();
        for (int i = 0; i < orderedListOfSubprotocolsAndNames.size(); ++i) {
            String subprotocolName = orderedListOfSubprotocolsAndNames.get(i).getKey();
            SigmaProtocolTranscript subtranscript = orderedListOfSubprotocolsAndNames.get(i).getValue().decompressTranscript(compressedTranscript.list().get(i + 2), challenge, variableResponses.fallbackTo(externalResponse));
            subprotocolAnnouncements.put(subprotocolName, subtranscript.getAnnouncement());
            subprotocolResponses.put(subprotocolName, subtranscript.getResponse());
        }
        return new SigmaProtocolTranscript(new SendThenDelegateAnnouncement(spec, subprotocolAnnouncements, sendFirstValue), challenge, new SendThenDelegateResponse(subprotocolResponses, variableResponses));
    }

    @Override
    public void debugFragment(SchnorrVariableAssignment externalWitness, ZnChallengeSpace challengeSpace) {
        ProverSpec proverSpec = this.provideProverSpec(externalWitness, new ProverSpecBuilder(this));
        SubprotocolSpec subprotocolSpec = this.provideSubprotocolSpec(proverSpec.sendFirstValue, new SubprotocolSpecBuilder());
        if (!this.provideAdditionalCheck(proverSpec.sendFirstValue).evaluate().booleanValue()) {
            throw new RuntimeException("additional send first value check failed");
        }
        proverSpec.subprotocolSpec.forEachProtocol((name, fragment) -> {
            try {
                fragment.debugFragment(proverSpec.witnesses.fallbackTo(externalWitness), challengeSpace);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error in subfragment " + name, e);
            }
        });
    }

    public static class ProverSpecBuilder {
        private SendFirstValue sendFirstValue;
        private SubprotocolSpec subprotocolSpec;
        private final Map<String, SchnorrVariableValue> witnessesForVariables = new HashMap<String, SchnorrVariableValue>();
        private final Map<String, Zn.ZnElement> znWitnesses = new HashMap<String, Zn.ZnElement>();
        private final Map<String, GroupElement> groupElemWitnesses = new HashMap<String, GroupElement>();
        private boolean isBuilt = false;
        private final SendThenDelegateFragment fragment;

        public ProverSpecBuilder(SendThenDelegateFragment fragment) {
            this.fragment = fragment;
        }

        public void setSendFirstValue(SendFirstValue sendFirstValue) {
            if (this.sendFirstValue != null) {
                throw new IllegalStateException("Cannot overwrite sendFirstValue");
            }
            this.sendFirstValue = sendFirstValue;
            this.subprotocolSpec = this.fragment.provideSubprotocolSpec(sendFirstValue, new SubprotocolSpecBuilder());
        }

        public void putWitnessValue(String variableName, Zn.ZnElement witnessValue) {
            this.checkDuplicate(variableName);
            this.znWitnesses.put(variableName, witnessValue);
        }

        public void putWitnessValue(String variableName, GroupElement witnessValue) {
            this.checkDuplicate(variableName);
            this.groupElemWitnesses.put(variableName, witnessValue);
        }

        private void checkDuplicate(String name) {
            if (this.witnessesForVariables.containsKey(name) || this.znWitnesses.containsKey(name) || this.groupElemWitnesses.containsKey(name)) {
                throw new IllegalArgumentException("Witness " + name + " is already registered.");
            }
        }

        private WitnessValues buildWitnessValues() {
            this.znWitnesses.forEach((name, val) -> {
                if (!this.subprotocolSpec.containsVariable((String)name)) {
                    throw new IllegalStateException("Variable " + name + " has not been registered in the subprotocol spec, but its witness has been given in the prover spec");
                }
                this.witnessesForVariables.put((String)name, new SchnorrZnVariableValue((Zn.ZnElement)val, (SchnorrZnVariable)this.subprotocolSpec.getVariable((String)name)));
            });
            this.groupElemWitnesses.forEach((name, val) -> {
                if (!this.subprotocolSpec.containsVariable((String)name)) {
                    throw new IllegalStateException("Variable " + name + " has not been registered in the subprotocol spec, but its witness has been given in the prover spec");
                }
                this.witnessesForVariables.put((String)name, new SchnorrGroupElemVariableValue((GroupElement)val, (SchnorrGroupElemVariable)this.subprotocolSpec.getVariable((String)name)));
            });
            this.subprotocolSpec.forEachVariable((name, var) -> {
                if (!this.witnessesForVariables.containsKey(name)) {
                    throw new IllegalStateException("Witness for " + name + " is missing");
                }
            });
            return new WitnessValues(this.witnessesForVariables);
        }

        public ProverSpec build() {
            if (this.isBuilt) {
                throw new IllegalStateException("has already been built");
            }
            this.isBuilt = true;
            if (this.sendFirstValue == null || this.subprotocolSpec == null) {
                throw new IllegalStateException("sendFirstValue is not set or subprotocolSpec is null");
            }
            return new ProverSpec(this.sendFirstValue, this.subprotocolSpec, this.buildWitnessValues());
        }
    }

    public static class ProverSpec {
        public final SendFirstValue sendFirstValue;
        public final SubprotocolSpec subprotocolSpec;
        public final WitnessValues witnesses;

        private ProverSpec(SendFirstValue sendFirstValue, SubprotocolSpec subprotocolSpec, WitnessValues witnesses) {
            this.sendFirstValue = sendFirstValue;
            this.subprotocolSpec = subprotocolSpec;
            this.witnesses = witnesses;
        }
    }

    public static class WitnessValues
    extends SchnorrVariableValueList {
        private WitnessValues(Map<String, SchnorrVariableValue> witnessesForVariables) {
            super(witnessesForVariables);
        }
    }

    public static class SubprotocolSpecBuilder {
        private final HashMap<String, SchnorrFragment> subprotocols = new HashMap();
        private final HashMap<String, SchnorrVariable> variables = new HashMap();
        private boolean isBuilt = false;

        public SubprotocolSpec build() {
            this.checkIsBuilt();
            this.isBuilt = true;
            return new SubprotocolSpec(this.subprotocols, this.variables);
        }

        public SchnorrZnVariable addZnVariable(String name, Zn zn) {
            return this.addVariable(name, new SchnorrZnVariable(name, zn));
        }

        public SchnorrGroupElemVariable addGroupElemVariable(String name, Group group) {
            return this.addVariable(name, new SchnorrGroupElemVariable(name, group));
        }

        public void addSubprotocol(String name, SchnorrFragment fragment) {
            this.checkIsBuilt();
            if (this.subprotocols.containsKey(name)) {
                throw new IllegalArgumentException("Subprotocol with name " + name + " already exists.");
            }
            this.subprotocols.put(name, fragment);
        }

        private <T extends SchnorrVariable> T addVariable(String name, T variable) {
            this.checkIsBuilt();
            if (this.variables.containsKey(name)) {
                throw new IllegalArgumentException("Variable with name " + name + " already exists.");
            }
            this.variables.put(name, variable);
            return variable;
        }

        private void checkIsBuilt() {
            if (this.isBuilt) {
                throw new IllegalStateException("Builder already finished.");
            }
        }
    }

    public static class SubprotocolSpec {
        private final Map<String, SchnorrFragment> subprotocols;
        private final Map<String, SchnorrVariable> variables;

        private SubprotocolSpec(Map<String, SchnorrFragment> subprotocols, Map<String, SchnorrVariable> variables) {
            this.subprotocols = subprotocols;
            this.variables = variables;
        }

        public SchnorrVariableValueList createVariableAssignment(BiFunction<String, SchnorrVariable, SchnorrVariableValue> mapper) {
            return new SchnorrVariableValueList(this.variables.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (SchnorrVariableValue)mapper.apply((String)entry.getKey(), (SchnorrVariable)entry.getValue())).collect(Collectors.toList()));
        }

        public SchnorrVariableValueList createRandomVariableAssignment() {
            return this.createVariableAssignment((k, v) -> v.generateRandomValue());
        }

        public <T> Map<String, T> mapSubprotocols(BiFunction<String, SchnorrFragment, T> mapper) {
            HashMap result = new HashMap();
            this.subprotocols.forEach((name, subprotocol) -> result.put(name, mapper.apply((String)name, (SchnorrFragment)subprotocol)));
            return result;
        }

        public void forEachVariable(BiConsumer<String, SchnorrVariable> consumer) {
            this.variables.forEach(consumer);
        }

        public void forEachProtocol(BiConsumer<String, SchnorrFragment> consumer) {
            this.subprotocols.forEach(consumer);
        }

        public void forEachProtocolOrdered(BiConsumer<String, SchnorrFragment> consumer) {
            this.getOrderedListOfSubprotocolsAndNames().forEach(entry -> consumer.accept((String)entry.getKey(), (SchnorrFragment)entry.getValue()));
        }

        public List<Map.Entry<String, SchnorrFragment>> getOrderedListOfSubprotocolsAndNames() {
            return this.subprotocols.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        }

        public List<SchnorrVariable> getOrderedListOfVariables() {
            return this.variables.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        }

        public boolean containsSubprotocol(String subprotocolName) {
            return this.subprotocols.containsKey(subprotocolName);
        }

        public boolean containsVariable(String variableName) {
            return this.variables.containsKey(variableName);
        }

        public boolean containsVariable(SchnorrVariable variable) {
            return this.variables.get(variable.name) == variable;
        }

        public SchnorrVariable getVariable(String variableName) {
            return this.variables.get(variableName);
        }
    }

    private static class SendThenDelegateResponse
    implements Response {
        @UniqueByteRepresented
        private final Map<String, Response> subprotocolResponses;
        @UniqueByteRepresented
        private final SchnorrVariableValueList variableResponses;

        public SendThenDelegateResponse(Map<String, Response> subprotocolResponses, SchnorrVariableValueList variableResponses) {
            this.subprotocolResponses = subprotocolResponses;
            this.variableResponses = variableResponses;
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
        }

        public Representation getRepresentation() {
            ListRepresentation result = new ListRepresentation();
            result.add(this.variableResponses.getRepresentation());
            this.subprotocolResponses.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).forEachOrdered(v -> result.add(v.getRepresentation()));
            return result;
        }
    }

    protected static class SendThenDelegateAnnouncement
    implements Announcement {
        @UniqueByteRepresented
        public final HashMap<String, Announcement> subprotocolAnnouncements = new HashMap();
        @UniqueByteRepresented
        public final SendFirstValue sendFirstValue;
        public final SubprotocolSpec subprotocolSpec;

        public SendThenDelegateAnnouncement(SubprotocolSpec subprotocolSpec, Map<String, ? extends Announcement> subprotocolAnnouncements, SendFirstValue sendFirstValue) {
            this.subprotocolSpec = subprotocolSpec;
            this.subprotocolAnnouncements.putAll(subprotocolAnnouncements);
            this.sendFirstValue = sendFirstValue;
        }

        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
            return accumulator;
        }

        public Representation getRepresentation() {
            ListRepresentation result = new ListRepresentation();
            result.add(this.sendFirstValue.getRepresentation());
            this.subprotocolAnnouncements.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(Representable::getRepresentation).forEachOrdered(arg_0 -> ((ListRepresentation)result).add(arg_0));
            return result;
        }
    }

    private static class SendThenDelegateAnnouncementSecret
    implements AnnouncementSecret {
        public final SchnorrVariableAssignment randomVariableValues;
        public final ProverSpec proverSpec;
        public final Map<String, AnnouncementSecret> subprotocolAnnouncementSecret;
        public final SubprotocolSpec subprotocolSpec;
        public final SendFirstValue sendFirstValue;
        public final WitnessValues witnessValues;

        public SendThenDelegateAnnouncementSecret(SchnorrVariableAssignment randomVariableValues, ProverSpec proverSpec, Map<String, AnnouncementSecret> subprotocolAnnouncementSecret) {
            this.randomVariableValues = randomVariableValues;
            this.proverSpec = proverSpec;
            this.subprotocolAnnouncementSecret = subprotocolAnnouncementSecret;
            this.subprotocolSpec = proverSpec.subprotocolSpec;
            this.sendFirstValue = proverSpec.sendFirstValue;
            this.witnessValues = proverSpec.witnesses;
        }
    }
}

