/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrGroupElemVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariable;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableValue;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class SchnorrGroupElemVariableValue
implements SchnorrVariableValue {
    protected final GroupElement value;
    protected final SchnorrGroupElemVariable variable;

    public SchnorrGroupElemVariableValue(GroupElement value, SchnorrGroupElemVariable variable) {
        this.value = value;
        if (value == null) {
            throw new NullPointerException();
        }
        this.variable = variable;
    }

    public Representation getRepresentation() {
        return this.value.getRepresentation();
    }

    @Override
    public SchnorrGroupElemVariableValue evalLinear(BigInteger factor, SchnorrVariableValue summand) {
        return new SchnorrGroupElemVariableValue(this.value.pow(factor).op((Element)((SchnorrGroupElemVariableValue)summand).value), this.variable);
    }

    @Override
    public SchnorrVariable getVariable() {
        return this.variable;
    }

    public GroupElementExpression asExpression() {
        return this.getValue().expr();
    }

    public GroupElement getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchnorrGroupElemVariableValue that = (SchnorrGroupElemVariableValue)o;
        return this.value.equals(that.value) && Objects.equals(this.variable, that.variable);
    }

    public int hashCode() {
        return Objects.hash(this.variable);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator.append((UniqueByteRepresentable)this.value);
        return accumulator;
    }
}

