/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrVariableValue;
import org.cryptimeleon.craco.protocols.arguments.sigma.schnorr.variables.SchnorrZnVariable;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class SchnorrZnVariableValue
implements SchnorrVariableValue {
    protected final Zn.ZnElement value;
    protected final SchnorrZnVariable variable;

    public SchnorrZnVariableValue(Zn.ZnElement value, SchnorrZnVariable variable) {
        this.value = value;
        if (value == null) {
            throw new NullPointerException();
        }
        this.variable = variable;
    }

    public Representation getRepresentation() {
        return this.value.getRepresentation();
    }

    @Override
    public SchnorrZnVariableValue evalLinear(BigInteger factor, SchnorrVariableValue summand) {
        return new SchnorrZnVariableValue(this.value.mul(factor).add((Element)((SchnorrZnVariableValue)summand).value), this.variable);
    }

    @Override
    public SchnorrZnVariable getVariable() {
        return this.variable;
    }

    @Override
    public Expression asExpression() {
        return this.getValue().asExponentExpression();
    }

    public Zn.ZnElement getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchnorrZnVariableValue that = (SchnorrZnVariableValue)o;
        return this.value.equals((Object)that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator.append((UniqueByteRepresentable)this.value);
        return accumulator;
    }
}

