/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig;

import java.lang.reflect.Type;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;

public interface SignatureScheme
extends StandaloneRepresentable,
RepresentationRestorer {
    public Signature sign(PlainText var1, SigningKey var2);

    public Boolean verify(PlainText var1, Signature var2, VerificationKey var3);

    public PlainText restorePlainText(Representation var1);

    public Signature restoreSignature(Representation var1);

    public SigningKey restoreSigningKey(Representation var1);

    public VerificationKey restoreVerificationKey(Representation var1);

    default public Signature sign(Representation plainText, Representation secretKey) {
        return this.sign(this.restorePlainText(plainText), this.restoreSigningKey(secretKey));
    }

    default public Boolean verify(Representation plainText, Representation signature, Representation publicKey) {
        return this.verify(this.restorePlainText(plainText), this.restoreSignature(signature), this.restoreVerificationKey(publicKey));
    }

    public PlainText mapToPlaintext(byte[] var1, VerificationKey var2);

    public PlainText mapToPlaintext(byte[] var1, SigningKey var2);

    public int getMaxNumberOfBytesForMapToPlaintext();

    default public Object restoreFromRepresentation(Type type, Representation repr) {
        if (type instanceof Class) {
            if (SigningKey.class.isAssignableFrom((Class)type)) {
                return this.restoreSigningKey(repr);
            }
            if (VerificationKey.class.isAssignableFrom((Class)type)) {
                return this.restoreVerificationKey(repr);
            }
            if (Signature.class.isAssignableFrom((Class)type)) {
                return this.restoreSignature(repr);
            }
            if (PlainText.class.isAssignableFrom((Class)type)) {
                return this.restorePlainText(repr);
            }
        }
        throw new IllegalArgumentException("Cannot restore object of type: " + type.getTypeName());
    }
}

