/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ecdsa;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.StringRepresentation;

public class ECDSASigningKey
implements SigningKey,
StandaloneRepresentable {
    private final PrivateKey key;

    public ECDSASigningKey(PrivateKey secretKey) {
        this.key = secretKey;
    }

    public ECDSASigningKey(Representation repr) {
        byte[] encodedKey = Base64.getDecoder().decode(((StringRepresentation)repr).get());
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(encodedKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            this.key = keyFactory.generatePrivate(privKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    PrivateKey getKey() {
        return this.key;
    }

    public Representation getRepresentation() {
        String encodedKey = Base64.getEncoder().encodeToString(this.key.getEncoded());
        return new StringRepresentation(encodedKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECDSASigningKey that = (ECDSASigningKey)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

