/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.ps18;

import java.util.Objects;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class PS18SigningKey
implements SigningKey {
    @Represented(restorer="zp")
    private Zp.ZpElement exponentX;
    @Represented(restorer="zp")
    private RingElementVector exponentsYi;

    public PS18SigningKey(Zp.ZpElement exponentX, RingElementVector exponentsYi) {
        this.exponentX = exponentX;
        this.exponentsYi = exponentsYi;
    }

    public PS18SigningKey(Representation repr, Zp zp) {
        new ReprUtil((Object)this).register((RepresentationRestorer)zp, "zp").deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Zp.ZpElement getExponentX() {
        return this.exponentX;
    }

    public RingElementVector getExponentsYi() {
        return this.exponentsYi;
    }

    public int getNumberOfMessages() {
        return this.exponentsYi.length() - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PS18SigningKey that = (PS18SigningKey)o;
        return Objects.equals(this.exponentX, that.exponentX) && Objects.equals(this.exponentsYi, that.exponentsYi);
    }

    public int hashCode() {
        return Objects.hash(this.exponentX, this.exponentsYi);
    }
}

