/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps;

import java.util.Objects;
import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSPublicParameters
implements PublicParameters {
    @Represented
    protected BilinearGroup bilinearGroup;
    @Represented(restorer="bilinearGroup::getG1")
    protected GroupElement group1ElementG;
    @Represented(restorer="bilinearGroup::getG2")
    protected GroupElement group2ElementH;

    public SPSPublicParameters() {
    }

    public SPSPublicParameters(BilinearGroup bilinearGroup) {
        this.bilinearGroup = bilinearGroup;
        this.group1ElementG = this.bilinearGroup.getG1().getUniformlyRandomNonNeutral();
        this.group2ElementH = this.bilinearGroup.getG2().getUniformlyRandomNonNeutral();
        this.precompute();
    }

    public SPSPublicParameters(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public Zp getZp() {
        return new Zp(this.bilinearGroup.getG1().size());
    }

    public GroupElement getG1GroupGenerator() {
        return this.group1ElementG;
    }

    public GroupElement getG2GroupGenerator() {
        return this.group2ElementH;
    }

    public BilinearMap getBilinearMap() {
        return this.bilinearGroup.getBilinearMap();
    }

    public Group getGT() {
        return this.bilinearGroup.getGT();
    }

    private void precompute() {
        this.group1ElementG.precomputePow();
        this.group2ElementH.precomputePow();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SPSPublicParameters)) {
            return false;
        }
        SPSPublicParameters that = (SPSPublicParameters)o;
        return Objects.equals(this.bilinearGroup, that.bilinearGroup) && Objects.equals(this.group1ElementG, that.group1ElementG) && Objects.equals(this.group2ElementH, that.group2ElementH);
    }

    public int hashCode() {
        return Objects.hash(this.bilinearGroup, this.group1ElementG, this.group2ElementH);
    }

    public Representation getRepresentation() {
        return new ReprUtil((Object)this).serialize();
    }
}

