/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps;

import java.util.function.BiFunction;
import org.cryptimeleon.craco.sig.sps.SPSPublicParameters;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigBilinearGroup;

public class SPSPublicParametersGen {
    public static SPSPublicParameters generateParameters(int securityParameter, boolean debugMode) {
        Object group = debugMode ? new DebugBilinearGroup(RandomGenerator.getRandomPrime((int)securityParameter), BilinearGroup.Type.TYPE_3) : new BarretoNaehrigBilinearGroup(securityParameter);
        return new SPSPublicParameters((BilinearGroup)group);
    }

    public static <PPType extends SPSPublicParameters> PPType generateParameters(BiFunction<BilinearGroup, Integer, PPType> constructor, BilinearGroup bGroup, int messageLength) {
        return (PPType)((SPSPublicParameters)constructor.apply(bGroup, messageLength));
    }
}

