/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15;

import java.util.Objects;
import org.cryptimeleon.craco.sig.sps.SPSPublicParameters;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;

public class AKOT15SharedPublicParameters
extends SPSPublicParameters
implements Cloneable {
    @Represented
    protected Integer messageLength;

    public AKOT15SharedPublicParameters(BilinearGroup bilinearGroup, int messageLength) {
        super(bilinearGroup);
        this.bilinearGroup = bilinearGroup;
        this.messageLength = messageLength;
        this.group1ElementG = this.bilinearGroup.getG1().getUniformlyRandomNonNeutral();
        this.group2ElementH = this.bilinearGroup.getG2().getUniformlyRandomNonNeutral();
    }

    public AKOT15SharedPublicParameters(BilinearGroup bilinearGroup, int messageLength, GroupElement group1ElementG, GroupElement group2ElementH) {
        super(bilinearGroup);
        this.bilinearGroup = bilinearGroup;
        this.messageLength = messageLength;
        this.group1ElementG = group1ElementG;
        this.group2ElementH = group2ElementH;
    }

    public AKOT15SharedPublicParameters(Representation repr) {
        super(repr);
    }

    public BilinearGroup getBilinearGroup() {
        return this.bilinearGroup;
    }

    @Override
    public BilinearMap getBilinearMap() {
        return this.bilinearGroup.getBilinearMap();
    }

    public Integer getMessageLength() {
        return this.messageLength;
    }

    public void setMessageLength(int messageLength) {
        this.messageLength = messageLength;
    }

    @Override
    public Representation getRepresentation() {
        return new ReprUtil((Object)this).serialize();
    }

    public AKOT15SharedPublicParameters clone() {
        AKOT15SharedPublicParameters clone = new AKOT15SharedPublicParameters(this.bilinearGroup, this.messageLength, this.group1ElementG, this.group2ElementH);
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AKOT15SharedPublicParameters that = (AKOT15SharedPublicParameters)o;
        return Objects.equals(this.messageLength, that.messageLength);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.messageLength);
    }
}

