/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.pos;

import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSPOSSigningKey
implements SigningKey {
    @Represented(restorer="[Zp]")
    protected Zp.ZpElement[] exponentsChi;
    @Represented(restorer="Zp")
    protected Zp.ZpElement exponentW;
    @Represented(restorer="Zp")
    protected Zp.ZpElement exponentA;

    public SPSPOSSigningKey(Zp.ZpElement[] exponentsChi, Zp.ZpElement exponentW) {
        this.exponentsChi = exponentsChi;
        this.exponentW = exponentW;
    }

    public SPSPOSSigningKey(Representation repr, Zp zp) {
        new ReprUtil((Object)this).register((RepresentationRestorer)zp, "Zp").deserialize(repr);
    }

    public Zp.ZpElement[] getExponentsChi() {
        return this.exponentsChi;
    }

    public Zp.ZpElement getExponentW() {
        return this.exponentW;
    }

    public void setOneTimeKey(Zp.ZpElement oneTimeKey) {
        this.exponentA = oneTimeKey;
    }

    public Zp.ZpElement getOneTimeKey() {
        return this.exponentA;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SPSPOSSigningKey that = (SPSPOSSigningKey)o;
        return Arrays.equals(this.exponentsChi, that.exponentsChi) && Objects.equals(this.exponentW, that.exponentW);
    }

    public int hashCode() {
        int result = Objects.hash(this.exponentW);
        result = 31 * result + Arrays.hashCode(this.exponentsChi);
        return result;
    }
}

