/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tcgamma;

import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15Commitment;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class TCGAKOT15XSIGCommitment
extends TCGAKOT15Commitment {
    @Represented(restorer="G2")
    private GroupElement group2ElementGu2;
    @Represented(restorer="G2")
    private GroupElement group2ElementGu3;

    public TCGAKOT15XSIGCommitment(GroupElement group2ElementGu, GroupElement group2ElementGu2, GroupElement group2ElementGu3) {
        super(group2ElementGu);
        this.group2ElementGu2 = group2ElementGu2;
        this.group2ElementGu3 = group2ElementGu3;
    }

    public TCGAKOT15XSIGCommitment(Group group2, Representation repr) {
        super(group2, repr);
    }

    public GroupElement getGroup2ElementGu2() {
        return this.group2ElementGu2;
    }

    public GroupElement getGroup2ElementGu3() {
        return this.group2ElementGu3;
    }

    public MessageBlock toMessageBlock() {
        MessageBlock triple = new MessageBlock(new GroupElementPlainText(this.getGroup2ElementGu()), new GroupElementPlainText(this.group2ElementGu2), new GroupElementPlainText(this.group2ElementGu3));
        return new MessageBlock(new MessageBlock[]{triple});
    }

    @Override
    public Representation getRepresentation() {
        return new ReprUtil((Object)this).serialize();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TCGAKOT15XSIGCommitment that = (TCGAKOT15XSIGCommitment)o;
        return Objects.equals(this.group2ElementGu2, that.group2ElementGu2) && Objects.equals(this.group2ElementGu3, that.group2ElementGu3);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.group2ElementGu2, this.group2ElementGu3);
    }
}

