/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.xsig;

import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSXSIGPublicParameters
extends AKOT15SharedPublicParameters {
    @Represented(restorer="bilinearGroup::getG1")
    protected GroupElement group1ElementF1;
    @Represented(restorer="bilinearGroup::getG1")
    protected GroupElement group1ElementF2;
    @Represented(restorer="bilinearGroup::getG2")
    protected GroupElement group2ElementF1;
    @Represented(restorer="bilinearGroup::getG2")
    protected GroupElement group2ElementF2;
    @Represented(restorer="[bilinearGroup::getG1]")
    protected GroupElement[] group1ElementsU;
    @Represented(restorer="[bilinearGroup::getG2]")
    protected GroupElement[] group2ElementsU;

    public SPSXSIGPublicParameters(BilinearGroup bilinearGroup, int messageLength) {
        super(bilinearGroup, messageLength);
        this.bilinearGroup = bilinearGroup;
        this.messageLength = messageLength;
        this.group1ElementG = this.bilinearGroup.getG1().getUniformlyRandomNonNeutral();
        this.group2ElementH = this.bilinearGroup.getG2().getUniformlyRandomNonNeutral();
        this.generateRandomF();
        this.generateRandomU();
        this.precompute();
    }

    public SPSXSIGPublicParameters(AKOT15SharedPublicParameters sharedPP, int messageLength) {
        super(sharedPP.getBilinearGroup(), messageLength);
        this.group1ElementG = sharedPP.getG1GroupGenerator();
        this.group2ElementH = sharedPP.getG2GroupGenerator();
        this.generateRandomF();
        this.generateRandomU();
        this.precompute();
    }

    public SPSXSIGPublicParameters(Representation repr) {
        super(repr);
    }

    private void generateRandomF() {
        Zp.ZpElement delta = this.getZp().getUniformlyRandomNonzeroElement();
        Zp.ZpElement phi = this.getZp().getUniformlyRandomNonzeroElement();
        this.group1ElementF1 = this.group1ElementG.pow((Zn.ZnElement)phi).compute();
        this.group2ElementF1 = this.group2ElementH.pow((Zn.ZnElement)phi).compute();
        this.group1ElementF2 = this.group1ElementG.pow((Zn.ZnElement)delta).compute();
        this.group2ElementF2 = this.group2ElementH.pow((Zn.ZnElement)delta).compute();
    }

    private void generateRandomU() {
        this.group1ElementsU = new GroupElement[this.messageLength.intValue()];
        this.group2ElementsU = new GroupElement[this.messageLength.intValue()];
        for (int i = 0; i < this.messageLength; ++i) {
            Zp.ZpElement ui = this.getZp().getUniformlyRandomNonzeroElement();
            this.group1ElementsU[i] = this.group1ElementG.pow((Zn.ZnElement)ui).compute();
            this.group2ElementsU[i] = this.group2ElementH.pow((Zn.ZnElement)ui).compute();
        }
    }

    private void precompute() {
        this.group1ElementF1.precomputePow();
        this.group2ElementF1.precomputePow();
        this.group1ElementF2.precomputePow();
        this.group2ElementF2.precomputePow();
        Arrays.stream(this.group1ElementsU).forEach(x -> x.precomputePow());
        Arrays.stream(this.group2ElementsU).forEach(x -> x.precomputePow());
    }

    @Override
    public BilinearGroup getBilinearGroup() {
        return this.bilinearGroup;
    }

    public void setBilinearGroup(BilinearGroup bilinearGroup) {
        this.bilinearGroup = bilinearGroup;
    }

    public GroupElement getGroup1ElementG() {
        return this.group1ElementG;
    }

    public GroupElement getGroup2ElementH() {
        return this.group2ElementH;
    }

    public GroupElement getGroup1ElementF1() {
        return this.group1ElementF1;
    }

    public GroupElement getGroup1ElementF2() {
        return this.group1ElementF2;
    }

    public GroupElement getGroup2ElementF1() {
        return this.group2ElementF1;
    }

    public GroupElement getGroup2ElementF2() {
        return this.group2ElementF2;
    }

    public GroupElement[] getGroup1ElementsU() {
        return this.group1ElementsU;
    }

    public GroupElement[] getGroup2ElementsU() {
        return this.group2ElementsU;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SPSXSIGPublicParameters that = (SPSXSIGPublicParameters)o;
        return Objects.equals(this.group1ElementF1, that.group1ElementF1) && Objects.equals(this.group1ElementF2, that.group1ElementF2) && Objects.equals(this.group2ElementF1, that.group2ElementF1) && Objects.equals(this.group2ElementF2, that.group2ElementF2) && Arrays.equals(this.group1ElementsU, that.group1ElementsU) && Arrays.equals(this.group2ElementsU, that.group2ElementsU);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.group1ElementF1, this.group1ElementF2, this.group2ElementF1, this.group2ElementF2);
        result = 31 * result + Arrays.hashCode(this.group1ElementsU);
        result = 31 * result + Arrays.hashCode(this.group2ElementsU);
        return result;
    }
}

