/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.xsig;

import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.hash.annotations.UniqueByteRepresented;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class SPSXSIGSignature
implements Signature,
UniqueByteRepresentable {
    @UniqueByteRepresented
    @Represented(restorer="G2")
    protected GroupElement group2ElementSigma0;
    @UniqueByteRepresented
    @Represented(restorer="[G1]")
    protected GroupElement[] group1ElementsSigma;

    public SPSXSIGSignature(Representation repr, Group G1, Group G2) {
        new ReprUtil((Object)this).register((RepresentationRestorer)G1, "G1").register((RepresentationRestorer)G2, "G2").deserialize(repr);
    }

    public SPSXSIGSignature(GroupElement group2ElementSigma0, GroupElement[] group1ElementsSigma) {
        if (group1ElementsSigma.length != 5) {
            throw new IllegalArgumentException("The signature requires exactly 5 G1-GroupElements, but got: " + group1ElementsSigma.length);
        }
        this.group2ElementSigma0 = group2ElementSigma0;
        this.group1ElementsSigma = group1ElementsSigma;
    }

    public GroupElement getGroup2ElementSigma0() {
        return this.group2ElementSigma0;
    }

    public GroupElement[] getGroup1ElementsSigma() {
        return this.group1ElementsSigma;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SPSXSIGSignature that = (SPSXSIGSignature)o;
        return Objects.equals(this.group2ElementSigma0, that.group2ElementSigma0) && Arrays.equals(this.group1ElementsSigma, that.group1ElementsSigma);
    }

    public int hashCode() {
        int result = Objects.hash(this.group2ElementSigma0);
        result = 31 * result + Arrays.hashCode(this.group1ElementsSigma);
        return result;
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }
}

