/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.xsig;

import java.util.Objects;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.sig.MultiMessageStructurePreservingSignatureScheme;
import org.cryptimeleon.craco.sig.Signature;
import org.cryptimeleon.craco.sig.SignatureKeyPair;
import org.cryptimeleon.craco.sig.SigningKey;
import org.cryptimeleon.craco.sig.VerificationKey;
import org.cryptimeleon.craco.sig.sps.SPSMessageSpaceVerifier;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSignature;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGSigningKey;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGVerificationKey;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSXSIGSignatureScheme
implements MultiMessageStructurePreservingSignatureScheme,
SPSMessageSpaceVerifier {
    @Represented
    private SPSXSIGPublicParameters pp;

    public SPSXSIGSignatureScheme(SPSXSIGPublicParameters pp) {
        this.pp = pp;
    }

    public SPSXSIGSignatureScheme(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public SPSXSIGPublicParameters getPublicParameters() {
        return this.pp;
    }

    public SignatureKeyPair<SPSXSIGVerificationKey, SPSXSIGSigningKey> generateKeyPair(int numberOfMessages) {
        if (this.pp.getMessageLength() != numberOfMessages) {
            throw new IllegalArgumentException(String.format("The scheme expected messageLength %d, but was: %d", this.pp.getMessageLength(), numberOfMessages));
        }
        Zp.ZpElement r0 = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement r1 = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement r2 = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement phi = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement alpha = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement a = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement b = this.pp.getZp().getUniformlyRandomElement();
        GroupElement groupElementG = this.pp.getGroup1ElementG();
        GroupElement groupElementGHat = this.pp.getGroup2ElementH();
        GroupElement group2ElementV1 = groupElementGHat.pow((Zn.ZnElement)b).compute();
        GroupElement group2ElementV2 = groupElementGHat.pow((Zn.ZnElement)a).compute();
        GroupElement group2ElementV3 = groupElementGHat.pow((Zn.ZnElement)a.mul((Element)b)).compute();
        GroupElement group2ElementV4 = groupElementGHat.pow((Zn.ZnElement)r0.add((Element)a.mul((Element)r1))).compute();
        GroupElement group2ElementV5 = group2ElementV4.pow((Zn.ZnElement)b).compute();
        GroupElement group2ElementV6 = groupElementGHat.pow((Zn.ZnElement)r2).compute();
        GroupElement group1ElementV7 = groupElementG.pow((Zn.ZnElement)phi).compute();
        GroupElement group2ElementV8 = !phi.isZero() ? groupElementGHat.pow((Zn.ZnElement)alpha.mul((Element)b).div((Element)phi)).compute() : groupElementGHat.getStructure().getUniformlyRandomElement();
        GroupElement group1ElementK1 = groupElementG.pow((Zn.ZnElement)alpha).compute();
        GroupElement group1ElementK2 = groupElementG.pow((Zn.ZnElement)b).compute();
        GroupElement group1ElementK3 = groupElementG.pow((Zn.ZnElement)r0).compute();
        GroupElement group1ElementK4 = groupElementG.pow((Zn.ZnElement)r1).compute();
        SPSXSIGVerificationKey vk = new SPSXSIGVerificationKey(group2ElementV1, group2ElementV2, group2ElementV3, group2ElementV4, group2ElementV5, group2ElementV6, group1ElementV7, group2ElementV8);
        SPSXSIGSigningKey sk = new SPSXSIGSigningKey(group2ElementV6, group1ElementK1, group1ElementK2, group1ElementK3, group1ElementK4);
        return new SignatureKeyPair<SPSXSIGVerificationKey, SPSXSIGSigningKey>(vk, sk);
    }

    @Override
    public Signature sign(PlainText plainText, SigningKey secretKey) {
        this.doMessageChecks(plainText);
        MessageBlock messageBlock = (MessageBlock)plainText;
        if (!(secretKey instanceof SPSXSIGSigningKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        SPSXSIGSigningKey sk = (SPSXSIGSigningKey)secretKey;
        Zp.ZpElement r0 = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement r1 = this.pp.getZp().getUniformlyRandomElement();
        Zp.ZpElement r = r0.add((Element)r1);
        Zp.ZpElement z = this.pp.getZp().getUniformlyRandomElement();
        GroupElement group2ElementS0 = sk.getGroup2ElementV6();
        for (int i = 0; i < messageBlock.length(); ++i) {
            GroupElementPlainText m_i3 = (GroupElementPlainText)((MessageBlock)messageBlock.get(i)).get(2);
            group2ElementS0 = group2ElementS0.op((Element)m_i3.get());
        }
        group2ElementS0 = group2ElementS0.pow((Zn.ZnElement)r0).compute();
        GroupElement group1ElementS1 = sk.getGroup1ElementK1().op((Element)sk.getGroup1ElementK3().pow((Zn.ZnElement)r)).compute();
        GroupElement group1ElementS2 = sk.getGroup1ElementK4().pow((Zn.ZnElement)r);
        GroupElement group1ElementS2rhs = this.pp.getGroup1ElementG().pow((Zn.ZnElement)z.neg()).compute();
        group1ElementS2 = group1ElementS2.op((Element)group1ElementS2rhs).compute();
        GroupElement group1ElementS3 = sk.getGroup1ElementK2().pow((Zn.ZnElement)z).compute();
        GroupElement group1ElementS4 = sk.getGroup1ElementK2().pow((Zn.ZnElement)r1).compute();
        GroupElement group1ElementS5 = this.pp.getGroup1ElementG().pow((Zn.ZnElement)r0).compute();
        return new SPSXSIGSignature(group2ElementS0, new GroupElement[]{group1ElementS1, group1ElementS2, group1ElementS3, group1ElementS4, group1ElementS5});
    }

    @Override
    public Boolean verify(PlainText plainText, Signature signature, VerificationKey publicKey) {
        this.doMessageChecks(plainText);
        if (!(publicKey instanceof SPSXSIGVerificationKey)) {
            throw new IllegalArgumentException("Not a valid signing key for this scheme");
        }
        if (!(signature instanceof SPSXSIGSignature)) {
            throw new IllegalArgumentException("Not a valid signature for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        SPSXSIGVerificationKey vk = (SPSXSIGVerificationKey)publicKey;
        SPSXSIGSignature sigma = (SPSXSIGSignature)signature;
        BilinearMap bMap = this.pp.getBilinearMap();
        return this.verifyFirstPPE(bMap, sigma, vk, messageBlock) && this.verifySecondPPE(bMap, sigma, vk) && this.verifyThirdPPE(bMap, messageBlock) && this.verifyFourthPPE(bMap, messageBlock);
    }

    private boolean verifyFirstPPE(BilinearMap bMap, SPSXSIGSignature sigma, SPSXSIGVerificationKey vk, MessageBlock messageBlock) {
        GroupElement ppe1lhs2 = vk.getGroup2ElementV6();
        for (int i = 0; i < messageBlock.length(); ++i) {
            GroupElementPlainText m_i3 = (GroupElementPlainText)((MessageBlock)messageBlock.get(i)).get(2);
            ppe1lhs2 = ppe1lhs2.op((Element)m_i3.get());
        }
        ppe1lhs2 = ppe1lhs2.compute();
        GroupElement ppe1lhs = bMap.apply(sigma.getGroup1ElementsSigma()[4], ppe1lhs2).compute();
        GroupElement ppe1rhs = bMap.apply(this.pp.getGroup1ElementG(), sigma.getGroup2ElementSigma0()).compute();
        return ppe1lhs.equals(ppe1rhs);
    }

    private boolean verifySecondPPE(BilinearMap bMap, SPSXSIGSignature sigma, SPSXSIGVerificationKey vk) {
        GroupElement ppe2lhs = bMap.apply(sigma.getGroup1ElementsSigma()[0], vk.getGroup2ElementV1());
        ppe2lhs = ppe2lhs.op((Element)bMap.apply(sigma.getGroup1ElementsSigma()[1], vk.getGroup2ElementV3()));
        ppe2lhs = ppe2lhs.op((Element)bMap.apply(sigma.getGroup1ElementsSigma()[2], vk.getGroup2ElementV2()));
        ppe2lhs.compute();
        GroupElement ppe2rhs = bMap.apply(sigma.getGroup1ElementsSigma()[3], vk.getGroup2ElementV4());
        ppe2rhs = ppe2rhs.op((Element)bMap.apply(sigma.getGroup1ElementsSigma()[4], vk.getGroup2ElementV5()));
        ppe2rhs = ppe2rhs.op((Element)bMap.apply(vk.getGroup1ElementV7(), vk.getGroup2ElementV8()));
        ppe2rhs.compute();
        return ppe2lhs.equals(ppe2rhs);
    }

    private boolean verifyThirdPPE(BilinearMap bMap, MessageBlock messageBlock) {
        for (int i = 0; i < messageBlock.length(); ++i) {
            MessageBlock innerBlock = (MessageBlock)messageBlock.get(i);
            GroupElement m_i1 = ((GroupElementPlainText)innerBlock.get(0)).get();
            GroupElement m_i3 = ((GroupElementPlainText)innerBlock.get(2)).get();
            GroupElement ppe3lhs = bMap.apply(this.pp.getGroup1ElementF1(), m_i3);
            ppe3lhs.compute();
            GroupElement ppe3rhs = bMap.apply(this.pp.getGroup1ElementsU()[i], m_i1);
            ppe3rhs.compute();
            if (ppe3lhs.equals(ppe3rhs)) continue;
            return false;
        }
        return true;
    }

    private boolean verifyFourthPPE(BilinearMap bMap, MessageBlock messageBlock) {
        for (int i = 0; i < messageBlock.length(); ++i) {
            MessageBlock innerBlock = (MessageBlock)messageBlock.get(i);
            GroupElement m_i2 = ((GroupElementPlainText)innerBlock.get(1)).get();
            GroupElement m_i3 = ((GroupElementPlainText)innerBlock.get(2)).get();
            GroupElement ppe3lhs = bMap.apply(this.pp.getGroup1ElementF2(), m_i3);
            ppe3lhs.compute();
            GroupElement ppe3rhs = bMap.apply(this.pp.getGroup1ElementsU()[i], m_i2);
            ppe3rhs.compute();
            if (ppe3lhs.equals(ppe3rhs)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void doMessageChecks(PlainText plainText, int expectedMessageLength, Group expectedGroup) {
        this.doMessageChecks(plainText);
    }

    private void doMessageChecks(PlainText plainText) {
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("The scheme requires its messages to a MessageBlock");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        if (messageBlock.length() != this.pp.getMessageLength().intValue()) {
            throw new IllegalArgumentException(String.format("The scheme expected a message of length %d, but the size was: %d", this.pp.getMessageLength(), messageBlock.length()));
        }
        for (int i = 0; i < messageBlock.length(); ++i) {
            if (!(messageBlock.get(i) instanceof MessageBlock)) {
                throw new IllegalArgumentException(String.format("The scheme requires its messages to only contain inner MessageBlocks, but element %d was %s", i, ((PlainText)messageBlock.get(i)).getClass()));
            }
            MessageBlock innerBlock = (MessageBlock)messageBlock.get(i);
            if (innerBlock.length() != 3) {
                throw new IllegalArgumentException(String.format("The scheme requires its inner MessageBlocks to contain three elements, but element %d contained: %d elements", i, innerBlock.length()));
            }
            for (int j = 0; j < innerBlock.length(); ++j) {
                if (!(innerBlock.get(j) instanceof GroupElementPlainText)) {
                    throw new IllegalArgumentException(String.format("The scheme requires its inner MessageBlocks to contain GroupElements, but element %d was of type: %s", i, ((PlainText)messageBlock.get(i)).getClass().toString()));
                }
                GroupElementPlainText groupElementPT = (GroupElementPlainText)innerBlock.get(j);
                if (groupElementPT.get().getStructure().equals(this.pp.getG2GroupGenerator().getStructure())) continue;
                throw new IllegalArgumentException(String.format("Expected message elements to be in G_2, but element %d in inner MessageBlock %d was in: %s", j, i, groupElementPT.get().getStructure().toString()));
            }
        }
    }

    @Override
    public PlainText restorePlainText(Representation repr) {
        ListRepresentation messageList = (ListRepresentation)repr;
        Representation[] messageTripletsRepr = new Representation[messageList.size()];
        for (int i = 0; i < messageTripletsRepr.length; ++i) {
            messageTripletsRepr[i] = messageList.get(i);
        }
        PlainText[] messageTriplets = new MessageBlock[messageTripletsRepr.length];
        for (int i = 0; i < messageTripletsRepr.length; ++i) {
            messageTriplets[i] = new MessageBlock(messageTripletsRepr[i], r -> new GroupElementPlainText((Representation)r, this.pp.getG2GroupGenerator().getStructure()));
        }
        return new MessageBlock(messageTriplets);
    }

    @Override
    public Signature restoreSignature(Representation repr) {
        return new SPSXSIGSignature(repr, this.pp.getG1GroupGenerator().getStructure(), this.pp.getG2GroupGenerator().getStructure());
    }

    @Override
    public SigningKey restoreSigningKey(Representation repr) {
        return new SPSXSIGSigningKey(this.pp.getG1GroupGenerator().getStructure(), this.pp.getG2GroupGenerator().getStructure(), repr);
    }

    @Override
    public VerificationKey restoreVerificationKey(Representation repr) {
        return new SPSXSIGVerificationKey(this.pp.getG1GroupGenerator().getStructure(), this.pp.getG2GroupGenerator().getStructure(), repr);
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, VerificationKey pk) {
        if (this.pp == null) {
            throw new NullPointerException("Number of messages is stored in public parameters but they are not set");
        }
        return this.mapToPlaintext(bytes, this.pp.getMessageLength());
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes, SigningKey sk) {
        if (this.pp == null) {
            throw new NullPointerException("Number of messages is stored in public parameters but they are not set");
        }
        return this.mapToPlaintext(bytes, this.pp.getMessageLength());
    }

    private MessageBlock mapToPlaintext(byte[] bytes, int messageBlockLength) {
        PlainText[] msgBlock = new GroupElementPlainText[messageBlockLength];
        msgBlock[0] = new GroupElementPlainText(this.pp.getG1GroupGenerator().pow((Zn.ZnElement)this.pp.getZp().injectiveValueOf(bytes)));
        for (int i = 1; i < msgBlock.length; ++i) {
            msgBlock[i] = new GroupElementPlainText(this.pp.getG1GroupGenerator());
        }
        return new MessageBlock(new MessageBlock(msgBlock), new MessageBlock(new PlainText[0]));
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getG1GroupGenerator().getStructure().size().bitLength() - 1) / 8;
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SPSXSIGSignatureScheme that = (SPSXSIGSignatureScheme)o;
        return Objects.equals(this.pp, that.pp);
    }

    public int hashCode() {
        return Objects.hash(this.pp);
    }
}

