/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.bool;

import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.bool.BoolAndExpr;
import org.cryptimeleon.math.expressions.bool.BoolConstantExpr;
import org.cryptimeleon.math.expressions.bool.BoolNotExpr;
import org.cryptimeleon.math.expressions.bool.BoolOrExpr;
import org.cryptimeleon.math.expressions.bool.LazyBoolEvaluationResult;

public interface BooleanExpression
extends Expression {
    public static final BoolConstantExpr TRUE = new BoolConstantExpr(true);
    public static final BoolConstantExpr FALSE = new BoolConstantExpr(false);

    @Override
    public BooleanExpression substitute(Substitution var1);

    @Override
    default public BooleanExpression substitute(String variable, Expression substitution) {
        return (BooleanExpression)Expression.super.substitute(variable, substitution);
    }

    @Override
    default public BooleanExpression substitute(VariableExpression variable, Expression substitution) {
        return (BooleanExpression)Expression.super.substitute(variable, substitution);
    }

    @Override
    default public Boolean evaluate() {
        return this.evaluate(e -> null);
    }

    @Override
    public Boolean evaluate(Substitution var1);

    public LazyBoolEvaluationResult evaluateLazy(Substitution var1);

    default public LazyBoolEvaluationResult evaluateLazy() {
        return this.evaluateLazy(e -> null);
    }

    default public BooleanExpression and(BooleanExpression rhs) {
        return new BoolAndExpr(this, rhs);
    }

    default public BooleanExpression or(BooleanExpression rhs) {
        return new BoolOrExpr(this, rhs);
    }

    default public BooleanExpression not() {
        return new BoolNotExpr(this);
    }

    public static BooleanExpression valueOf(boolean bool) {
        return bool ? TRUE : FALSE;
    }
}

