/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.exponent;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentEmptyExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ExponentInvExpr
implements ExponentExpr {
    protected final ExponentExpr child;

    public ExponentInvExpr(ExponentExpr child) {
        this.child = child;
    }

    public ExponentExpr getChild() {
        return this.child;
    }

    @Override
    public BigInteger evaluate() {
        throw new IllegalArgumentException("Cannot invert element over Z. Use evaluate(Zn) instead.");
    }

    @Override
    public Zn.ZnElement evaluate(Zn zn) {
        return this.child.evaluate(zn).inv();
    }

    @Override
    public ExponentExpr substitute(Substitution substitutions) {
        return this.child.substitute(substitutions).invert();
    }

    @Override
    public ExponentSumExpr linearize() throws IllegalArgumentException {
        if (this.child.containsVariables()) {
            throw new IllegalArgumentException("Cannot linearize - inversion of variables isn't linear");
        }
        return new ExponentSumExpr(this, new ExponentEmptyExpr());
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.child);
    }
}

