/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.exponent;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentEmptyExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.misc.BigIntegerTools;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ExponentPowExpr
implements ExponentExpr {
    protected final ExponentExpr base;
    protected final ExponentExpr exponent;

    public ExponentPowExpr(ExponentExpr base, ExponentExpr exponent) {
        this.base = base;
        this.exponent = exponent;
    }

    public ExponentExpr getBase() {
        return this.base;
    }

    public ExponentExpr getExponent() {
        return this.exponent;
    }

    @Override
    public BigInteger evaluate() {
        return this.base.evaluate().pow(BigIntegerTools.getExactInt(this.exponent.evaluate()));
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.base);
        action.accept(this.exponent);
    }

    @Override
    public Zn.ZnElement evaluate(Zn zn) {
        return this.base.evaluate(zn).pow(this.exponent.evaluate());
    }

    @Override
    public ExponentExpr substitute(Substitution substitutions) {
        return this.base.substitute(substitutions).pow(this.exponent.substitute(substitutions));
    }

    @Override
    public ExponentSumExpr linearize() throws IllegalArgumentException {
        if (this.exponent.containsVariables()) {
            throw new IllegalArgumentException("Cannot linearize expression a^b, where b contains variables.");
        }
        if (this.base.containsVariables()) {
            throw new IllegalArgumentException("Cannot linearize expression a^b, where a contains variables.");
        }
        return new ExponentSumExpr(this, new ExponentEmptyExpr());
    }
}

