/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.group;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentEmptyExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.expressions.group.AbstractGroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupEmptyExpr;
import org.cryptimeleon.math.expressions.group.GroupOpExpr;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class GroupPowExpr
extends AbstractGroupElementExpression {
    protected GroupElementExpression base;
    protected ExponentExpr exponent;

    public GroupPowExpr(GroupElementExpression base, ExponentExpr exponent) {
        super(base.getGroup());
        this.base = base;
        this.exponent = exponent;
    }

    @Override
    public GroupElement evaluate(Substitution substitutions) {
        BigInteger groupOrder = this.getGroupOrderIfKnown();
        if (groupOrder == null) {
            return this.base.evaluate(substitutions).pow(this.exponent.evaluate(substitutions));
        }
        return this.base.evaluate(substitutions).pow(this.exponent.evaluate(this.getGroup().getZn(), substitutions));
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.base);
        action.accept(this.exponent);
    }

    @Override
    public GroupElementExpression substitute(Substitution substitutions) {
        return this.base.substitute(substitutions).pow(this.exponent.substitute(substitutions));
    }

    public GroupElementExpression getBase() {
        return this.base;
    }

    public ExponentExpr getExponent() {
        return this.exponent;
    }

    @Override
    public GroupElementExpression pow(ExponentExpr exp) {
        return new GroupPowExpr(this.base, this.exponent.mul(exp));
    }

    @Override
    public GroupOpExpr linearize() throws IllegalArgumentException {
        boolean baseHasVariables = this.base.containsVariables();
        boolean exponentHasVariables = this.exponent.containsVariables();
        if (baseHasVariables && exponentHasVariables) {
            throw new IllegalArgumentException("Cannot linearize this expression (it's of the form g^x, where both g and x depend on variables)");
        }
        if (!baseHasVariables && !exponentHasVariables) {
            return new GroupOpExpr(this, new GroupEmptyExpr(this.base.getGroup()));
        }
        if (baseHasVariables) {
            GroupOpExpr baseLinear = this.base.linearize();
            if (baseLinear.getLhs() instanceof GroupEmptyExpr) {
                return new GroupOpExpr(new GroupEmptyExpr(this.base.getGroup()), this);
            }
            return new GroupOpExpr(baseLinear.getLhs().pow(this.exponent), baseLinear.getRhs().pow(this.exponent));
        }
        ExponentSumExpr exponentLinear = this.exponent.linearize();
        if (exponentLinear.getLhs() instanceof ExponentEmptyExpr) {
            return new GroupOpExpr(new GroupEmptyExpr(this.base.getGroup()), this);
        }
        return new GroupOpExpr(this.base.pow(exponentLinear.getLhs()), this.base.pow(exponentLinear.getRhs()));
    }

    @Override
    public GroupOpExpr flatten(ExponentExpr exp) {
        return this.base.flatten(exp.mul(this.exponent));
    }
}

