/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.hash.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.cryptimeleon.math.hash.impl.HashAccumulator;

public class SHAHashAccumulator
extends HashAccumulator {
    protected final MessageDigest digest;

    public SHAHashAccumulator(String algorithm) {
        try {
            this.digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void append(byte[] bytes) {
        this.digest.update(bytes);
    }

    @Override
    public byte[] extractBytes() {
        return this.digest.digest();
    }
}

