/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.random;

import java.math.BigInteger;
import org.cryptimeleon.math.random.RandomGeneratorImpl;
import org.cryptimeleon.math.random.SecureRandomGeneratorImpl;

public class RandomGenerator {
    public static RandomGeneratorImpl impl = new SecureRandomGeneratorImpl();

    private RandomGenerator() {
    }

    public static BigInteger getRandomNumber(BigInteger exclusiveUpperBound) {
        return impl.getRandomNumber(exclusiveUpperBound);
    }

    public static long getRandomNumber(long exclusiveUpperBound) {
        return RandomGenerator.getRandomNumber(BigInteger.valueOf(exclusiveUpperBound)).longValue();
    }

    public static int getRandomNumber(int exclusiveUpperBound) {
        return RandomGenerator.getRandomNumber(BigInteger.valueOf(exclusiveUpperBound)).intValue();
    }

    public static BigInteger getRandomNumber(BigInteger inclusiveLowerBound, BigInteger exclusiveUpperBound) {
        return impl.getRandomNumber(inclusiveLowerBound, exclusiveUpperBound);
    }

    public static long getRandomNumber(long inclusiveLowerBound, long exclusiveUpperBound) {
        return impl.getRandomNumber(BigInteger.valueOf(inclusiveLowerBound), BigInteger.valueOf(exclusiveUpperBound)).longValue();
    }

    public static int getRandomNumber(int inclusiveLowerBound, int exclusiveUpperBound) {
        return impl.getRandomNumber(BigInteger.valueOf(inclusiveLowerBound), BigInteger.valueOf(exclusiveUpperBound)).intValue();
    }

    public static BigInteger getRandomNonZeroNumber(BigInteger exclusiveUpperBound) {
        return RandomGenerator.getRandomNumber(BigInteger.ONE, exclusiveUpperBound);
    }

    public static BigInteger getRandomNumberOfBitlength(int bitlength) {
        return impl.getRandomNumberOfBitlength(bitlength);
    }

    public static byte[] getRandomBytes(int l) {
        return impl.getRandomBytes(l);
    }

    public static boolean getRandomBit() {
        return impl.getRandomBit();
    }

    public static BigInteger getRandomPrime(int bitlength) {
        return impl.getRandomPrime(bitlength);
    }
}

