/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.cryptimeleon.math.serialization.MapRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.RepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;

class MapRepresentationHandler
implements RepresentationHandler {
    protected RepresentationHandler keyHandler;
    protected RepresentationHandler valueHandler;
    protected Class<?> mapType;
    protected Type keyType;
    protected Type valueType;

    public MapRepresentationHandler(RepresentationHandler keyHandler, RepresentationHandler valueHandler, Type mapType) {
        this.keyHandler = keyHandler;
        this.valueHandler = valueHandler;
        this.mapType = (Class)((ParameterizedType)mapType).getRawType();
        this.keyType = MapRepresentationHandler.getKeyType(mapType);
        this.valueType = MapRepresentationHandler.getValueType(mapType);
    }

    public static Type getKeyType(Type mapType) {
        Type[] typeArguments = ((ParameterizedType)mapType).getActualTypeArguments();
        if (typeArguments.length != 2) {
            throw new IllegalArgumentException("Can only handle maps with two generic type arguments");
        }
        return typeArguments[0];
    }

    public static Type getValueType(Type mapType) {
        Type[] typeArguments = ((ParameterizedType)mapType).getActualTypeArguments();
        if (typeArguments.length != 2) {
            throw new IllegalArgumentException("Can only handle maps with two generic type arguments");
        }
        return typeArguments[1];
    }

    public static boolean canHandle(Type mapType) {
        if (!(mapType instanceof ParameterizedType)) {
            return false;
        }
        Type rawType = ((ParameterizedType)mapType).getRawType();
        if (!(rawType instanceof Class)) {
            return false;
        }
        if (!Map.class.isAssignableFrom((Class)rawType)) {
            return false;
        }
        try {
            MapRepresentationHandler.getKeyType(mapType);
            MapRepresentationHandler.getValueType(mapType);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            ((Class)rawType).getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return ((Class)rawType).isInterface() && ((Class)rawType).isAssignableFrom(LinkedHashMap.class);
        }
        return true;
    }

    @Override
    public Object deserializeFromRepresentation(Representation repr, Function<String, RepresentationRestorer> getRegisteredRestorer) {
        if (repr == null) {
            return null;
        }
        LinkedHashMap<Object, Object> result = null;
        try {
            result = (LinkedHashMap<Object, Object>)this.mapType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            if (this.mapType.isAssignableFrom(LinkedHashMap.class)) {
                result = new LinkedHashMap<Object, Object>();
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException("An error occured during invocation of the constructor of " + this.mapType.getSimpleName(), e);
        }
        if (result == null) {
            throw new RuntimeException("Cannot instantiate type " + this.mapType.getName());
        }
        for (Map.Entry<Representation, Representation> entry : repr.map()) {
            result.put(this.keyHandler.deserializeFromRepresentation(entry.getKey(), getRegisteredRestorer), this.valueHandler.deserializeFromRepresentation(entry.getValue(), getRegisteredRestorer));
        }
        return result;
    }

    @Override
    public Representation serializeToRepresentation(Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException("Cannot handle representation of " + obj.getClass().getName());
        }
        MapRepresentation repr = new MapRepresentation();
        ((Map)obj).forEach((k, v) -> repr.put(this.keyHandler.serializeToRepresentation(k), this.valueHandler.serializeToRepresentation(v)));
        return repr;
    }
}

