/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.converter;

import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.converter.JSONConverter;

public class JSONPrettyConverter
extends JSONConverter {
    @Override
    public String serialize(Representation r) {
        return this.prettyPrintJson(super.serialize(r));
    }

    public String prettyPrintJson(String json) {
        int indent = 0;
        boolean inString = false;
        boolean ignoreNextChar = false;
        StringBuilder builder = new StringBuilder();
        for (char c : json.toCharArray()) {
            if (ignoreNextChar) {
                ignoreNextChar = false;
                builder.append(c);
                continue;
            }
            if (c == '\\') {
                ignoreNextChar = true;
                builder.append(c);
                continue;
            }
            if (c == '\"') {
                inString = !inString;
                builder.append(c);
                continue;
            }
            if (!(inString || c != '{' && c != '[')) {
                builder.append(c);
                this.writeNewlineAndIndent(++indent, builder);
                continue;
            }
            if (!(inString || c != '}' && c != ']')) {
                this.writeNewlineAndIndent(--indent, builder);
                builder.append(c);
                continue;
            }
            if (!inString && c == ',') {
                builder.append(c);
                this.writeNewlineAndIndent(indent, builder);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private void writeNewlineAndIndent(int indent, StringBuilder builder) {
        builder.append("\n");
        for (int i = 0; i < indent; ++i) {
            builder.append("   ");
        }
    }
}

