/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.exp;

import java.util.ArrayList;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;

public class SmallExponentPrecomputation {
    GroupElementImpl base;
    ArrayList<GroupElementImpl> oddPowers = null;
    ArrayList<GroupElementImpl> oddNegativePowers = null;
    int windowSize = 0;
    int negativeWindowSize = 0;

    public SmallExponentPrecomputation(GroupElementImpl base) {
        this.base = base;
    }

    public int getCurrentMaxPositiveExponent() {
        return this.oddPowers == null ? 0 : 2 * this.oddPowers.size() - 1;
    }

    public int getCurrentMaxNegativeExponent() {
        return this.oddNegativePowers == null ? 0 : -2 * this.oddNegativePowers.size() + 1;
    }

    public int getCurrentlySupportedPositiveWindowSize() {
        return this.windowSize;
    }

    public int getCurrentlySupportedNegativeWindowSize() {
        return this.negativeWindowSize;
    }

    public int getCurrentlySupportedWindowSize() {
        return Math.max(this.windowSize, this.negativeWindowSize);
    }

    public GroupElementImpl get(int exponent) {
        if (exponent == 0) {
            return this.base.getStructure().getNeutralElement();
        }
        if (exponent < 0) {
            return this.getOddNegativePower(exponent);
        }
        if (exponent % 2 != 1) {
            return this.get(exponent - 1).op(this.base);
        }
        return this.getOddPositivePower(exponent);
    }

    public GroupElementImpl getOddPositivePower(int exponent) {
        if (this.getCurrentMaxPositiveExponent() < exponent) {
            return this.getOddNegativePower(-exponent).inv();
        }
        int index = (exponent - 1) / 2;
        return this.oddPowers.get(index);
    }

    public GroupElementImpl getOddNegativePower(int exponent) {
        if (this.getCurrentMaxNegativeExponent() > exponent) {
            return this.getOddPositivePower(-exponent).inv();
        }
        int index = (-exponent - 1) / 2;
        return this.oddNegativePowers.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute(int windowSize, boolean invertExisting) {
        if (this.windowSize < windowSize) {
            int maximumPower = (1 << windowSize) - 1;
            int numElements = (maximumPower + 1) / 2;
            SmallExponentPrecomputation smallExponentPrecomputation = this;
            synchronized (smallExponentPrecomputation) {
                if (this.windowSize < windowSize) {
                    if (this.oddPowers == null) {
                        this.oddPowers = new ArrayList(numElements);
                        this.oddPowers.add(this.base);
                    }
                    if (invertExisting && this.oddNegativePowers != null) {
                        for (int i = this.oddPowers.size(); i < this.oddNegativePowers.size(); ++i) {
                            this.oddPowers.add(i, this.oddNegativePowers.get(i).inv());
                        }
                    }
                    GroupElementImpl square = this.base.square();
                    GroupElementImpl currentSmallPower = this.oddPowers.get(this.oddPowers.size() - 1);
                    for (int i = this.oddPowers.size(); i < numElements; ++i) {
                        currentSmallPower = currentSmallPower.op(square);
                        this.oddPowers.add(i, currentSmallPower);
                    }
                    this.windowSize = windowSize;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeNegativePowers(int windowSize, boolean invertExisting) {
        if (this.negativeWindowSize < windowSize) {
            int maximumPower = (1 << windowSize) - 1;
            int numElements = (maximumPower + 1) / 2;
            SmallExponentPrecomputation smallExponentPrecomputation = this;
            synchronized (smallExponentPrecomputation) {
                if (this.negativeWindowSize < windowSize) {
                    GroupElementImpl invBase = this.base.inv();
                    if (this.oddNegativePowers == null) {
                        this.oddNegativePowers = new ArrayList(numElements);
                        this.oddNegativePowers.add(invBase);
                    }
                    if (invertExisting && this.oddPowers != null) {
                        for (int i = this.oddNegativePowers.size(); i < this.oddPowers.size(); ++i) {
                            this.oddNegativePowers.add(i, this.oddPowers.get(i).inv());
                        }
                    }
                    GroupElementImpl square = invBase.square();
                    GroupElementImpl currentSmallPower = this.oddNegativePowers.get(this.oddNegativePowers.size() - 1);
                    for (int i = this.oddNegativePowers.size(); i < numElements; ++i) {
                        currentSmallPower = currentSmallPower.op(square);
                        this.oddNegativePowers.add(i, currentSmallPower);
                    }
                    this.negativeWindowSize = windowSize;
                }
            }
        }
    }
}

