/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.lazy;

import java.math.BigInteger;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.exp.Multiexponentiation;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;

class ExpLazyGroupElement
extends LazyGroupElement {
    LazyGroupElement base;
    BigInteger exponent;

    public ExpLazyGroupElement(LazyGroup group, LazyGroupElement base, BigInteger exponent) {
        super(group);
        this.base = base;
        this.exponent = exponent;
    }

    @Override
    protected void computeConcreteValue() {
        this.setConcreteValue(this.group.compute(this.base.getConcreteValue(), this.exponent, this.base.getPrecomputedSmallExponents()));
    }

    @Override
    protected GroupElementImpl accumulateMultiexp(Multiexponentiation multiexp) {
        if (this.isDefinitelySupposedToGetConcreteValue()) {
            return this.getConcreteValue();
        }
        multiexp.put(this.base.getConcreteValue(), this.exponent, this.base.getPrecomputedSmallExponents());
        return null;
    }
}

