/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.lazy;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.exp.ExpAlgorithm;
import org.cryptimeleon.math.structures.groups.exp.ExponentiationAlgorithms;
import org.cryptimeleon.math.structures.groups.exp.MultiExpAlgorithm;
import org.cryptimeleon.math.structures.groups.exp.Multiexponentiation;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;
import org.cryptimeleon.math.structures.groups.lazy.ConstLazyGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.NeutralLazyGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.RandomGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.RandomNonNeutralGroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class LazyGroup
implements Group {
    static final ExecutorService executor = ForkJoinPool.commonPool();
    int exponentiationWindowSize = 4;
    int precomputationWindowSize = 8;
    @Represented
    GroupImpl impl;
    BigInteger size;
    boolean isPrimeOrder;
    Zn zn;
    GroupElement generator;
    MultiExpAlgorithm selectedMultiExpAlgorithm;
    ExpAlgorithm selectedExpAlgorithm;

    public LazyGroup(GroupImpl impl) {
        this(impl, 4, 8);
    }

    public LazyGroup(GroupImpl impl, int exponentiationWindowSize, int precomputationWindowSize) {
        this.impl = impl;
        this.exponentiationWindowSize = exponentiationWindowSize;
        this.precomputationWindowSize = precomputationWindowSize;
        this.init();
    }

    private void init() {
        this.size = this.impl.size();
        if (this.size == null || !this.impl.isCommutative()) {
            throw new IllegalArgumentException("Need commutative cyclic group of finite known order.");
        }
        this.generator = this.wrap(this.impl.getGenerator());
        this.isPrimeOrder = this.size.isProbablePrime(100);
        Zn zn = this.zn = this.isPrimeOrder ? new Zp(this.size) : new Zn(this.size);
        if (this.impl.estimateCostInvPerOp() >= 1.5) {
            this.selectedMultiExpAlgorithm = MultiExpAlgorithm.WNAF;
            this.selectedExpAlgorithm = ExpAlgorithm.WNAF;
        } else {
            this.selectedMultiExpAlgorithm = MultiExpAlgorithm.SLIDING;
            this.selectedExpAlgorithm = ExpAlgorithm.SLIDING;
        }
    }

    public LazyGroup(Representation repr) {
        ReprUtil.deserialize(this, repr);
        this.init();
    }

    public LazyGroup(Representation repr, int exponentiationWindowSize, int precomputationWindowSize) {
        ReprUtil.deserialize(this, repr);
        this.exponentiationWindowSize = exponentiationWindowSize;
        this.precomputationWindowSize = precomputationWindowSize;
        this.init();
    }

    public LazyGroupElement wrap(GroupElementImpl impl) {
        return new ConstLazyGroupElement(this, impl);
    }

    @Override
    public GroupElement getNeutralElement() {
        return new NeutralLazyGroupElement(this);
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.size;
    }

    @Override
    public boolean hasPrimeSize() {
        return this.isPrimeOrder;
    }

    @Override
    public GroupElement getUniformlyRandomElement() throws UnsupportedOperationException {
        return new RandomGroupElement(this);
    }

    @Override
    public GroupElement getUniformlyRandomNonNeutral() throws UnsupportedOperationException {
        return new RandomNonNeutralGroupElement(this);
    }

    @Override
    public GroupElement restoreElement(Representation repr) {
        return this.wrap(this.impl.restoreElement(repr));
    }

    @Override
    public GroupElement getGenerator() throws UnsupportedOperationException {
        return this.generator;
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.impl.getUniqueByteLength();
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public Zn getZn() {
        return this.zn;
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyGroup lazyGroup = (LazyGroup)o;
        return this.impl.equals(lazyGroup.impl);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }

    public String toString() {
        return "Lazy " + this.impl.toString();
    }

    public GroupElementImpl compute(Multiexponentiation multiexp) {
        if (multiexp.isEmpty()) {
            return this.impl.getNeutralElement();
        }
        if (this.impl.implementsOwnMultiExp()) {
            return this.impl.multiexp(multiexp);
        }
        switch (this.selectedMultiExpAlgorithm) {
            case SLIDING: {
                return ExponentiationAlgorithms.interleavingSlidingWindowMultiExp(multiexp, Math.max(this.exponentiationWindowSize, multiexp.computeMinPrecomputedWindowSize(MultiExpAlgorithm.SLIDING)));
            }
            case WNAF: {
                return ExponentiationAlgorithms.interleavingWnafMultiExp(multiexp, Math.max(this.exponentiationWindowSize, multiexp.computeMinPrecomputedWindowSize(MultiExpAlgorithm.WNAF)));
            }
        }
        throw new IllegalStateException("Unsupported MultiExpAlgorithm " + (Object)((Object)this.selectedMultiExpAlgorithm));
    }

    public GroupElementImpl compute(GroupElementImpl base, BigInteger exponent, SmallExponentPrecomputation precomputation) {
        if (this.impl.implementsOwnExp()) {
            return this.impl.exp(base, exponent, precomputation);
        }
        switch (this.selectedExpAlgorithm) {
            case SLIDING: {
                return ExponentiationAlgorithms.slidingWindowExp(base, exponent, precomputation, this.exponentiationWindowSize);
            }
            case WNAF: {
                return ExponentiationAlgorithms.wnafExp(base, exponent, precomputation, this.exponentiationWindowSize);
            }
        }
        throw new IllegalStateException("Unsupported ExpAlgorithm " + (Object)((Object)this.selectedExpAlgorithm));
    }

    public int getExponentiationWindowSize() {
        return this.exponentiationWindowSize;
    }

    public void setExponentiationWindowSize(int exponentiationWindowSize) {
        this.exponentiationWindowSize = exponentiationWindowSize;
    }

    public int getPrecomputationWindowSize() {
        return this.precomputationWindowSize;
    }

    public void setPrecomputationWindowSize(int precomputationWindowSize) {
        this.precomputationWindowSize = precomputationWindowSize;
    }

    public MultiExpAlgorithm getSelectedMultiExpAlgorithm() {
        return this.selectedMultiExpAlgorithm;
    }

    public void setSelectedMultiExpAlgorithm(MultiExpAlgorithm selectedMultiExpAlgorithm) {
        this.selectedMultiExpAlgorithm = selectedMultiExpAlgorithm;
    }

    public ExpAlgorithm getSelectedExpAlgorithm() {
        return this.selectedExpAlgorithm;
    }

    public void setSelectedExpAlgorithm(ExpAlgorithm selectedExpAlgorithm) {
        this.selectedExpAlgorithm = selectedExpAlgorithm;
    }

    public GroupImpl getImpl() {
        return this.impl;
    }
}

