/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.polynomial;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class LagrangeUtils {
    public static GroupElement interpolateInTheExponent(Map<BigInteger, GroupElement> givenElems, BigInteger newCoord) {
        if (givenElems.isEmpty()) {
            throw new IllegalArgumentException("Set of known evaluations is empty");
        }
        Set<BigInteger> xcoordinates = givenElems.keySet();
        Iterator<Map.Entry<BigInteger, GroupElement>> iterator = givenElems.entrySet().iterator();
        Map.Entry<BigInteger, GroupElement> firstEntry = iterator.next();
        Zp zp = (Zp)firstEntry.getValue().getStructure().getZn();
        GroupElement result = firstEntry.getValue().pow(LagrangeUtils.computeCoefficient(firstEntry.getKey(), xcoordinates, newCoord, zp));
        while (iterator.hasNext()) {
            Map.Entry<BigInteger, GroupElement> nextEntry = iterator.next();
            result = result.op(nextEntry.getValue().pow(LagrangeUtils.computeCoefficient(nextEntry.getKey(), xcoordinates, newCoord, zp)));
        }
        return result;
    }

    public static Zp.ZpElement computeCoefficient(Zp.ZpElement i, Set<Zp.ZpElement> S, Zp.ZpElement x) {
        Zp.ZpElement result = i.getStructure().getOneElement();
        for (Zp.ZpElement j : S) {
            if (j.equals(i)) continue;
            Zp.ZpElement numerator = x.sub(j);
            Zp.ZpElement denominator = i.sub(j);
            result = result.mul(numerator.div(denominator));
        }
        return result;
    }

    public static BigInteger computeCoefficient(BigInteger i, Set<BigInteger> S, BigInteger x, Zp field) {
        return LagrangeUtils.computeCoefficient(field.createZnElement(i), S.parallelStream().map(field::createZnElement).collect(Collectors.toSet()), field.createZnElement(x)).asInteger();
    }
}

