/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups;

import java.math.BigInteger;
import org.cryptimeleon.math.expressions.bool.GroupEqualityExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.GroupElementConstantExpr;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public interface GroupElement
extends Element,
UniqueByteRepresentable {
    @Override
    public Group getStructure();

    public GroupElement inv();

    public GroupElement op(Element var1) throws IllegalArgumentException;

    default public GroupElementExpression op(GroupElementExpression e) {
        return this.expr().op(e);
    }

    default public GroupElementExpression op(String variable) {
        return this.expr().op(variable);
    }

    default public GroupElement square() {
        return this.op(this);
    }

    public GroupElement pow(BigInteger var1);

    default public GroupElement pow(Zn.ZnElement k) {
        return this.pow((RingElement)k);
    }

    default public GroupElement pow(RingElement k) {
        if (!(this.getStructure().size().equals(k.getStructure().getCharacteristic()) || k.getStructure().getCharacteristic().equals(BigInteger.ZERO) || this.getStructure().size().mod(k.getStructure().getCharacteristic()).equals(BigInteger.ZERO))) {
            throw new IllegalArgumentException("Cannot raise to the power of " + k + " from " + k.getStructure());
        }
        return this.pow(k.asInteger());
    }

    default public GroupElement pow(long k) {
        return this.pow(BigInteger.valueOf(k));
    }

    default public GroupElementVector pow(Vector<? extends RingElement> exponents) {
        return GroupElementVector.generate(i -> this, exponents.length()).pow(exponents);
    }

    default public GroupElementExpression pow(ExponentExpr exponent) {
        return this.expr().pow(exponent);
    }

    default public GroupElementExpression pow(String variable) {
        return this.expr().pow(variable);
    }

    default public boolean isNeutralElement() {
        return this.equals(this.getStructure().getNeutralElement());
    }

    default public GroupElementConstantExpr expr() {
        return new GroupElementConstantExpr(this);
    }

    default public GroupEqualityExpr isEqualTo(GroupElementExpression expr) {
        return this.expr().isEqualTo(expr);
    }

    default public GroupEqualityExpr isEqualTo(String expr) {
        return this.expr().isEqualTo(expr);
    }

    default public GroupEqualityExpr isEqualTo(GroupElement other) {
        return this.expr().isEqualTo(other);
    }

    default public GroupElement precomputePow() {
        return this.precomputePow(8);
    }

    public GroupElement precomputePow(int var1);

    public GroupElement compute();

    public GroupElement computeSync();

    public boolean isComputed();
}

