/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.basic;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.basic.BasicGroup;
import org.cryptimeleon.math.structures.groups.exp.ExponentiationAlgorithms;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;

public class BasicGroupElement
implements GroupElement {
    protected BasicGroup group;
    protected GroupElementImpl impl;
    protected SmallExponentPrecomputation precomputedSmallExponents;

    public BasicGroupElement(BasicGroup group, GroupElementImpl impl) {
        this.group = group;
        this.impl = impl;
    }

    @Override
    public Group getStructure() {
        return this.group;
    }

    @Override
    public GroupElement inv() {
        return new BasicGroupElement(this.group, this.impl.inv());
    }

    @Override
    public GroupElement op(Element e) throws IllegalArgumentException {
        return new BasicGroupElement(this.group, this.impl.op(((BasicGroupElement)e).impl));
    }

    @Override
    public GroupElement square() {
        return new BasicGroupElement(this.group, this.impl.square());
    }

    @Override
    public GroupElement pow(BigInteger exponent) {
        return new BasicGroupElement(this.group, ExponentiationAlgorithms.wnafExp(this.impl, exponent, this.getPrecomputedSmallExponents(), 4));
    }

    @Override
    public boolean isNeutralElement() {
        return this.impl.isNeutralElement();
    }

    @Override
    public GroupElement precomputePow() {
        return this.precomputePow(8);
    }

    @Override
    public GroupElement precomputePow(int windowSize) {
        this.getPrecomputedSmallExponents().compute(windowSize, this.impl.getStructure().estimateCostInvPerOp() > 1.0);
        this.getPrecomputedSmallExponents().computeNegativePowers(windowSize, this.impl.getStructure().estimateCostInvPerOp() > 1.0);
        return this;
    }

    public SmallExponentPrecomputation getPrecomputedSmallExponents() {
        if (this.precomputedSmallExponents == null) {
            this.precomputedSmallExponents = new SmallExponentPrecomputation(this.impl);
        }
        return this.precomputedSmallExponents;
    }

    @Override
    public GroupElement compute() {
        return this;
    }

    @Override
    public GroupElement computeSync() {
        return this;
    }

    public GroupElementImpl getConcreteGroupElement() {
        return this.impl;
    }

    @Override
    public boolean isComputed() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicGroupElement that = (BasicGroupElement)o;
        return Objects.equals(this.impl, that.impl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.impl);
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        this.getConcreteGroupElement().updateAccumulator(accumulator);
        return accumulator;
    }

    @Override
    public Representation getRepresentation() {
        return this.getConcreteGroupElement().getRepresentation();
    }

    public String toString() {
        return this.impl.toString();
    }
}

