/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.basic;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.HashIntoGroup;
import org.cryptimeleon.math.structures.groups.basic.BasicGroup;
import org.cryptimeleon.math.structures.groups.basic.BasicGroupElement;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;

public class HashIntoBasicGroup
implements HashIntoGroup {
    @Represented
    protected HashIntoGroupImpl impl;
    @Represented
    protected BasicGroup target;

    public HashIntoBasicGroup(HashIntoGroupImpl hash, BasicGroup target) {
        this.impl = hash;
        this.target = target;
    }

    public HashIntoBasicGroup(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public BasicGroupElement hash(byte[] x) {
        return this.target.wrap(this.impl.hashIntoGroupImpl(x));
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashIntoBasicGroup that = (HashIntoBasicGroup)o;
        return this.impl.equals(that.impl) && this.target.equals(that.target);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }
}

